/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.twitter.elephantbird.util.Inflection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    public static String tableize(String word) {
        return Strings.pluralize(Strings.underscore(Strings.depackage(word)));
    }

    public static String pluralize(String word) {
        return Inflection.pluralize(word);
    }

    public static String singularize(String word) {
        return Inflection.singularize(word);
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.toLowerCase();
        return word;
    }

    public static String camelize(String word) {
        return Strings.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep2 = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep2 = rep2.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep2);
        }
        p = Pattern.compile("(__)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("\\$" + m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        return word;
    }

    public static String depackage(String word) {
        return word.replaceAll("^.*\\.", "");
    }

    public static String foreignKey(String className) {
        return Strings.foreignKey(className, true);
    }

    public static String foreignKey(String className, boolean separateIdWithUnderscore) {
        return Strings.underscore(Strings.depackage(className)) + (separateIdWithUnderscore ? "_id" : "id");
    }

    public static String titleize(String word) {
        word = Strings.humanize(Strings.underscore(word));
        Pattern p = Pattern.compile("\\b([a-z])");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(Strings.capitalize(m.group(1)));
            m = p.matcher(word);
        }
        return word;
    }

    public static String classify(String tableName) {
        return Strings.camelize(Strings.singularize(tableName.replaceAll(".*\\.", "")));
    }

    public static String humanize(String word) {
        word = word.replaceAll("_id", "");
        return Strings.capitalize(word.replaceAll("_", " "));
    }

    public static String ordinalize(int n) {
        int mod100 = n % 100;
        if (mod100 == 11 || mod100 == 12 || mod100 == 13) {
            return String.valueOf(n) + "th";
        }
        switch (n % 10) {
            case 1: {
                return String.valueOf(n) + "st";
            }
            case 2: {
                return String.valueOf(n) + "nd";
            }
            case 3: {
                return String.valueOf(n) + "rd";
            }
        }
        return String.valueOf(n) + "th";
    }

    public static String dasherize(String word) {
        return word.replaceAll("_", "-");
    }

    public static String capitalize(String word) {
        word = word.toLowerCase();
        word = word.substring(0, 1).toUpperCase() + word.substring(1);
        return word;
    }
}

