/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.twitter.elephantbird.mapreduce.input.combine.CompositeInputSplit;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SplitUtil.class);
    public static final String COMBINE_SPLIT_SIZE = "elephantbird.combine.split.size";
    private static Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return Long.signum(o1.length - o2.length);
        }
    };

    private static long getCombinedSplitSize(Configuration conf) throws IOException {
        long splitSize = conf.getLong(COMBINE_SPLIT_SIZE, -1L);
        if (splitSize == -1L) {
            splitSize = FileSystem.get((Configuration)conf).getDefaultBlockSize(new Path("."));
        }
        return splitSize;
    }

    private static void removeSplits(List<ComparableSplit> splits) {
        for (ComparableSplit split2 : splits) {
            split2.removeFromNodes();
        }
    }

    public static List<List<InputSplit>> getCombinedSplits(List<InputSplit> oneInputSplits, long maxCombinedSplitSize, Configuration conf) throws IOException, InterruptedException {
        ArrayList<InputSplit> combinedSplits;
        ArrayList<Node> nodes2 = new ArrayList<Node>();
        HashMap<Object, Node> nodeMap = new HashMap<Object, Node>();
        ArrayList<List<InputSplit>> result2 = new ArrayList<List<InputSplit>>();
        ArrayList<Long> resultLengths = new ArrayList<Long>();
        long comparableSplitId = 0L;
        int size2 = 0;
        int nSplits = oneInputSplits.size();
        InputSplit lastSplit = null;
        int emptyCnt = 0;
        for (InputSplit split2 : oneInputSplits) {
            if (split2.getLength() == 0L) {
                ++emptyCnt;
                continue;
            }
            if (split2.getLength() >= maxCombinedSplitSize) {
                ++comparableSplitId;
                ArrayList<InputSplit> combinedSplits2 = new ArrayList<InputSplit>();
                combinedSplits2.add(split2);
                result2.add(combinedSplits2);
                resultLengths.add(split2.getLength());
                continue;
            }
            ComparableSplit csplit = new ComparableSplit(split2, comparableSplitId++);
            Object[] locations = split2.getLocations();
            Arrays.sort(locations);
            HashSet<Object> locationSeen = new HashSet<Object>();
            for (Object location : locations) {
                if (locationSeen.contains(location)) continue;
                Node node = (Node)nodeMap.get(location);
                if (node == null) {
                    node = new Node();
                    nodes2.add(node);
                    nodeMap.put(location, node);
                }
                node.add(csplit);
                csplit.add(node);
                locationSeen.add(location);
            }
            lastSplit = split2;
            ++size2;
        }
        if (nSplits > 0 && emptyCnt == nSplits) {
            combinedSplits = new ArrayList<InputSplit>();
            combinedSplits.add(oneInputSplits.get(0));
            result2.add(combinedSplits);
        } else if (size2 == 1) {
            combinedSplits = new ArrayList();
            combinedSplits.add(lastSplit);
            result2.add(combinedSplits);
        } else if (size2 > 1) {
            Collections.sort(nodes2, nodeComparator);
            DummySplit dummy = new DummySplit();
            ComparableSplit dummyComparableSplit = new ComparableSplit(dummy, -1L);
            block2: for (Node node : nodes2) {
                node.sort();
                long totalSize = 0L;
                List<ComparableSplit> splits = node.getSplits();
                ArrayList<InputSplit> combinedSplits3 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                while (!splits.isEmpty()) {
                    combinedSplits3.add(splits.get(0).getSplit());
                    combinedComparableSplits.add(splits.get(0));
                    int startIdx = 1;
                    int lenSplits = splits.size();
                    long spaceLeft = maxCombinedSplitSize - (totalSize += splits.get(0).getSplit().getLength());
                    dummy.setLength(spaceLeft);
                    int idx = Collections.binarySearch(node.getSplits().subList(startIdx, lenSplits), dummyComparableSplit);
                    idx = -idx - 1 + startIdx;
                    while (idx < lenSplits) {
                        long thisLen = splits.get(idx).getSplit().getLength();
                        combinedSplits3.add(splits.get(idx).getSplit());
                        combinedComparableSplits.add(splits.get(idx));
                        totalSize += thisLen;
                        if ((spaceLeft -= thisLen) <= 0L || (startIdx = idx + 1) >= lenSplits) break;
                        dummy.setLength(spaceLeft);
                        idx = Collections.binarySearch(node.getSplits().subList(startIdx, lenSplits), dummyComparableSplit);
                        idx = -idx - 1 + startIdx;
                    }
                    if (totalSize > maxCombinedSplitSize / 2L) {
                        result2.add(combinedSplits3);
                        resultLengths.add(totalSize);
                        SplitUtil.removeSplits(combinedComparableSplits);
                        totalSize = 0L;
                        combinedSplits3 = new ArrayList();
                        combinedComparableSplits.clear();
                        splits = node.getSplits();
                        continue;
                    }
                    if (combinedSplits3.size() != lenSplits) {
                        throw new AssertionError((Object)"Combined split logic error!");
                    }
                    continue block2;
                }
            }
            ArrayList<ComparableSplit> leftoverSplits = new ArrayList<ComparableSplit>();
            HashSet<InputSplit> seen = new HashSet<InputSplit>();
            for (Node node : nodes2) {
                for (ComparableSplit split3 : node.getSplits()) {
                    if (seen.contains(split3.getSplit())) continue;
                    seen.add(split3.getSplit());
                    leftoverSplits.add(split3);
                }
            }
            if (!leftoverSplits.isEmpty()) {
                long totalSize = 0L;
                ArrayList<InputSplit> combinedSplits4 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                int splitLen = leftoverSplits.size();
                for (int i = 0; i < splitLen; ++i) {
                    ComparableSplit split4 = (ComparableSplit)leftoverSplits.get(i);
                    long thisLen = split4.getSplit().getLength();
                    if (totalSize + thisLen >= maxCombinedSplitSize) {
                        SplitUtil.removeSplits(combinedComparableSplits);
                        result2.add(combinedSplits4);
                        resultLengths.add(totalSize);
                        combinedSplits4 = new ArrayList();
                        combinedComparableSplits.clear();
                        totalSize = 0L;
                    }
                    combinedSplits4.add(split4.getSplit());
                    combinedComparableSplits.add(split4);
                    totalSize += split4.getSplit().getLength();
                    if (i != splitLen - 1) continue;
                    for (int j = 0; j < result2.size(); ++j) {
                        if ((Long)resultLengths.get(j) + totalSize > maxCombinedSplitSize) continue;
                        List isList = (List)result2.get(j);
                        for (InputSplit csplit : combinedSplits4) {
                            isList.add(csplit);
                        }
                        SplitUtil.removeSplits(combinedComparableSplits);
                        combinedSplits4.clear();
                        break;
                    }
                    if (combinedSplits4.isEmpty()) continue;
                    SplitUtil.removeSplits(combinedComparableSplits);
                    result2.add(combinedSplits4);
                }
            }
        }
        LOG.info("Original input paths (" + oneInputSplits.size() + ") combine into (" + result2.size() + ")");
        return result2;
    }

    public static List<CompositeInputSplit> getCombinedCompositeSplits(List<InputSplit> oneInputSplits, long maxCombinedSplitSize, Configuration conf) throws IOException, InterruptedException {
        ArrayList<CompositeInputSplit> compositeInputSplits = new ArrayList<CompositeInputSplit>(oneInputSplits.size());
        for (List<InputSplit> inputSplits : SplitUtil.getCombinedSplits(oneInputSplits, maxCombinedSplitSize, conf)) {
            compositeInputSplits.add(new CompositeInputSplit(inputSplits));
        }
        return compositeInputSplits;
    }

    public static List<CompositeInputSplit> getCombinedCompositeSplits(List<InputSplit> oneInputSplits, Configuration conf) throws IOException, InterruptedException {
        return SplitUtil.getCombinedCompositeSplits(oneInputSplits, SplitUtil.getCombinedSplitSize(conf), conf);
    }

    public static void serializeInputSplit(Configuration conf, DataOutputStream out, InputSplit split2) throws IOException {
        Class<InputSplit> clazz2 = split2.getClass().asSubclass(InputSplit.class);
        Text.writeString((DataOutput)out, (String)clazz2.getName());
        SerializationFactory factory = new SerializationFactory(conf);
        Serializer serializer = factory.getSerializer(clazz2);
        serializer.open((OutputStream)(out instanceof UncloseableDataOutputStream ? out : new UncloseableDataOutputStream(out)));
        serializer.serialize((Object)split2);
    }

    public static InputSplit deserializeInputSplit(Configuration conf, DataInputStream in) throws IOException {
        Class<InputSplit> clazz2;
        String name2 = Text.readString((DataInput)in);
        try {
            clazz2 = conf.getClassByName(name2).asSubclass(InputSplit.class);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find class for deserialized class name: " + name2, e);
        }
        return SplitUtil.deserializeInputSplitInternal(conf, in instanceof UncloseableDataInputStream ? in : new UncloseableDataInputStream(in), clazz2);
    }

    private static <T extends InputSplit> T deserializeInputSplitInternal(Configuration conf, DataInputStream in, Class<T> clazz2) throws IOException {
        InputSplit split2 = (InputSplit)ReflectionUtils.newInstance(clazz2, (Configuration)conf);
        SerializationFactory factory = new SerializationFactory(conf);
        Deserializer deserializer = factory.getDeserializer(clazz2);
        deserializer.open((InputStream)(in instanceof UncloseableDataInputStream ? in : new UncloseableDataInputStream(in)));
        return (T)((InputSplit)deserializer.deserialize((Object)split2));
    }

    private static class UncloseableDataInputStream
    extends DataInputStream {
        public UncloseableDataInputStream(DataInputStream is) {
            super(is);
        }

        @Override
        public void close() {
        }
    }

    private static class UncloseableDataOutputStream
    extends DataOutputStream {
        public UncloseableDataOutputStream(DataOutputStream os) {
            super(os);
        }

        @Override
        public void close() {
        }
    }

    private static class DummySplit
    extends InputSplit {
        private long length;

        private DummySplit() {
        }

        public String[] getLocations() {
            return null;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }
    }

    private static final class ComparableSplit
    implements Comparable<ComparableSplit> {
        private InputSplit rawInputSplit;
        private Set<Node> nodes;
        private long id;

        public ComparableSplit(InputSplit split2, long id) {
            this.rawInputSplit = split2;
            this.nodes = new HashSet<Node>();
            this.id = id;
        }

        public void add(Node node) {
            this.nodes.add(node);
        }

        public void removeFromNodes() {
            for (Node node : this.nodes) {
                node.remove(this);
            }
        }

        public InputSplit getSplit() {
            return this.rawInputSplit;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ComparableSplit)) {
                return false;
            }
            return this.compareTo((ComparableSplit)other) == 0;
        }

        public int hashCode() {
            int hashCode = 31 + this.rawInputSplit.hashCode();
            for (Node node : this.nodes) {
                hashCode = 17 * hashCode + node.hashCode();
            }
            return hashCode;
        }

        @Override
        public int compareTo(ComparableSplit other) {
            try {
                int cmp = -Long.signum(this.rawInputSplit.getLength() - other.rawInputSplit.getLength());
                return cmp == 0 ? Long.signum(this.id - other.id) : cmp;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Node {
        private long length = 0L;
        private List<ComparableSplit> splits = new ArrayList<ComparableSplit>();
        private boolean sorted = false;

        public void add(ComparableSplit split2) throws IOException, InterruptedException {
            this.splits.add(split2);
            ++this.length;
        }

        public void remove(ComparableSplit split2) {
            int index2;
            if (!this.sorted) {
                this.sort();
            }
            if ((index2 = Collections.binarySearch(this.splits, split2)) >= 0) {
                this.splits.remove(index2);
                --this.length;
            }
        }

        public void sort() {
            if (!this.sorted) {
                Collections.sort(this.splits);
                this.sorted = true;
            }
        }

        public List<ComparableSplit> getSplits() {
            return this.splits;
        }

        public long getLength() {
            return this.length;
        }
    }
}

