/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.UninitializedMessageException;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.ListHelper;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protobufs {
    private static final Logger LOG = LoggerFactory.getLogger(Protobufs.class);
    public static final byte[] KNOWN_GOOD_POSITION_MARKER = new byte[]{41, -40, -43, 6, 88, -51, 76, 41, -78, -68, 87, -103, 33, 113, -67, -1};
    public static final byte NEWLINE_UTF8_BYTE = 10;
    public static final byte[] NEWLINE_UTF8_BYTES = new byte[]{10};
    public static final String IGNORE_KEY = "IGNORE";
    private static final String CLASS_CONF_PREFIX = "elephantbird.protobuf.class.for.";

    public static Class<? extends Message> getProtobufClass(String protoClassName) {
        return Protobufs.getProtobufClass(null, protoClassName);
    }

    private static Class<? extends Message> getProtobufClass(Configuration conf, String protoClassName) {
        Class<Object> protoClass = null;
        try {
            protoClass = conf == null ? Class.forName(protoClassName) : conf.getClassByName(protoClassName);
        }
        catch (ClassNotFoundException e) {
            protoClass = Protobufs.getInnerProtobufClass(protoClassName);
        }
        return protoClass.asSubclass(Message.class);
    }

    public static boolean useDynamicProtoMessage(Class<?> protoClass) {
        return protoClass == null || protoClass.getCanonicalName().equals(DynamicMessage.class.getCanonicalName());
    }

    public static Class<? extends Message> getInnerProtobufClass(String canonicalClassName) {
        String parentClass = canonicalClassName.substring(0, canonicalClassName.lastIndexOf("."));
        String subclass = canonicalClassName.substring(canonicalClassName.lastIndexOf(".") + 1);
        return Protobufs.getInnerClass(parentClass, subclass);
    }

    public static Class<? extends Message> getInnerClass(String canonicalParentName, String subclassName) {
        try {
            Class<?> outerClass = Class.forName(canonicalParentName);
            for (Class<?> innerClass : outerClass.getDeclaredClasses()) {
                if (!innerClass.getSimpleName().equals(subclassName)) continue;
                return innerClass.asSubclass(Message.class);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not find class with parent " + canonicalParentName + " and inner class " + subclassName, e);
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    public static Message.Builder getMessageBuilder(Class<? extends Message> protoClass) {
        try {
            Method newBuilder2 = protoClass.getMethod("newBuilder", new Class[0]);
            return (Message.Builder)newBuilder2.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method newBuilder in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method newBuilder in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method newBuilder in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
    }

    public static Descriptors.Descriptor getMessageDescriptor(Class<? extends Message> protoClass) {
        try {
            Method getDescriptor = protoClass.getMethod("getDescriptor", new Class[0]);
            return (Descriptors.Descriptor)getDescriptor.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method getDescriptor in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method getDescriptor in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method getDescriptor in class " + protoClass, e);
            return null;
        }
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> protoClass) {
        return Lists.transform(Protobufs.getMessageDescriptor(protoClass).getFields(), new Function<Descriptors.FieldDescriptor, String>(){

            @Override
            public String apply(Descriptors.FieldDescriptor f2) {
                return f2.getName();
            }
        });
    }

    public static Descriptors.Descriptor makeMessageDescriptor(DescriptorProtos.DescriptorProto descProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescP = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descProto).build();
        Descriptors.FileDescriptor[] fileDescs = new Descriptors.FileDescriptor[]{};
        Descriptors.FileDescriptor dynamicDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescP, fileDescs);
        return dynamicDescriptor.findMessageTypeByName(descProto.getName());
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> protoClass, Map<String, String> fieldNameTranslations) {
        return Protobufs.getMessageFieldNames(Protobufs.getMessageDescriptor(protoClass), fieldNameTranslations);
    }

    public static List<String> getMessageFieldNames(Descriptors.Descriptor descriptor, Map<String, String> fieldNameTranslations) {
        Function<Descriptors.FieldDescriptor, String> fieldTransformer = Protobufs.getFieldTransformerFor(fieldNameTranslations);
        return ListHelper.filter(Lists.transform(descriptor.getFields(), fieldTransformer), Predicates.notNull());
    }

    public static Function<Descriptors.FieldDescriptor, String> getFieldTransformerFor(final Map<String, String> fieldNameTranslations) {
        return new Function<Descriptors.FieldDescriptor, String>(){

            @Override
            public String apply(Descriptors.FieldDescriptor f2) {
                String name2 = f2.getName();
                if (fieldNameTranslations != null && fieldNameTranslations.containsKey(name2)) {
                    name2 = (String)fieldNameTranslations.get(name2);
                }
                if (Protobufs.IGNORE_KEY.equals(name2)) {
                    name2 = null;
                }
                return name2;
            }
        };
    }

    public static <M extends Message> M parseFrom(Class<M> protoClass, byte[] messageBytes) {
        try {
            Method parseFrom = protoClass.getMethod("parseFrom", byte[].class);
            return (M)((Message)parseFrom.invoke(null, new Object[]{messageBytes}));
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method parseFrom in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method parseFrom in class " + protoClass, e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method parseFrom in class " + protoClass, e);
            return null;
        }
    }

    public static DynamicMessage parseDynamicFrom(Class<? extends Message> protoClass, byte[] messageBytes) {
        try {
            return DynamicMessage.parseFrom(Protobufs.getMessageDescriptor(protoClass), messageBytes);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Protocol buffer parsing error in parseDynamicFrom", e);
        }
        catch (UninitializedMessageException ume) {
            LOG.error("Uninitialized Message error in parseDynamicFrom " + protoClass.getName(), ume);
        }
        return null;
    }

    public static Message instantiateFromClassName(String canonicalClassName) {
        Class<? extends Message> protoClass = Protobufs.getInnerProtobufClass(canonicalClassName);
        Message.Builder builder = Protobufs.getMessageBuilder(protoClass);
        return builder.build();
    }

    public static <M extends Message> M instantiateFromClass(Class<M> protoClass) {
        return Protobufs.parseFrom(protoClass, new byte[0]);
    }

    public static Message addField(Message m, String name2, Object value2) {
        Message.Builder builder = m.toBuilder();
        Protobufs.setFieldByName(builder, name2, value2);
        return builder.build();
    }

    public static void setFieldByName(Message.Builder builder, String name2, Object value2) {
        Descriptors.FieldDescriptor fieldDescriptor = builder.getDescriptorForType().findFieldByName(name2);
        if (value2 == null) {
            builder.clearField(fieldDescriptor);
        } else {
            builder.setField(fieldDescriptor, value2);
        }
    }

    public static boolean isFieldSetByName(Message message, String name2) {
        return message.hasField(message.getDescriptorForType().findFieldByName(name2));
    }

    public static Object getFieldByName(Message message, String name2) {
        return message.getField(message.getDescriptorForType().findFieldByName(name2));
    }

    public static boolean hasFieldByName(Message message, String name2) {
        return message.getDescriptorForType().findFieldByName(name2) != null;
    }

    public static Descriptors.FieldDescriptor.Type getTypeByName(Message message, String name2) {
        return message.getDescriptorForType().findFieldByName(name2).getType();
    }

    public static <M extends Message> TypeRef<M> getTypeRef(String protoClassName) {
        return new TypeRef<M>(Protobufs.getProtobufClass(protoClassName)){};
    }

    public static <M extends Message> TypeRef<M> getTypeRef(Configuration jobConf, Class<?> genericClass) {
        String className = jobConf.get(CLASS_CONF_PREFIX + genericClass.getName());
        if (className == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + genericClass.getName() + " is not set");
        }
        return new TypeRef<M>(Protobufs.getProtobufClass(jobConf, className)){};
    }

    public static void setClassConf(Configuration jobConf, Class<?> genericClass, Class<? extends Message> protoClass) {
        HadoopUtils.setClassConf(jobConf, CLASS_CONF_PREFIX + genericClass.getName(), protoClass);
    }

    public static Text toText(Message message) {
        return new Text(message.toByteArray());
    }

    public static <B extends Message.Builder> B mergeFromText(B builder, Text bytes2) throws InvalidProtocolBufferException {
        Message.Builder b = builder.mergeFrom(bytes2.getBytes());
        return (B)b;
    }

    public static void writeFieldNoTag(CodedOutputStream output, Descriptors.FieldDescriptor fd, Object value2) throws IOException {
        if (value2 == null) {
            return;
        }
        if (fd.isRepeated()) {
            List values2 = (List)value2;
            for (Object obj : values2) {
                Protobufs.writeSingleFieldNoTag(output, fd, obj);
            }
        } else {
            Protobufs.writeSingleFieldNoTag(output, fd, value2);
        }
    }

    private static void writeSingleFieldNoTag(CodedOutputStream output, Descriptors.FieldDescriptor fd, Object value2) throws IOException {
        switch (fd.getType()) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value2);
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value2).floatValue());
                break;
            }
            case INT64: 
            case UINT64: {
                output.writeInt64NoTag((Long)value2);
                break;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value2);
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value2);
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value2);
                break;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value2);
                break;
            }
            case STRING: {
                output.writeStringNoTag((String)value2);
                break;
            }
            case GROUP: 
            case MESSAGE: {
                output.writeMessageNoTag((Message)value2);
                break;
            }
            case BYTES: {
                output.writeBytesNoTag((ByteString)value2);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value2);
                break;
            }
            case ENUM: {
                output.writeEnumNoTag(((ProtocolMessageEnum)value2).getNumber());
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value2);
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value2);
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value2);
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag(((Integer)value2).intValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)fd.getType()) + " for " + fd.getFullName());
            }
        }
    }

    public static void setFieldValue(CodedInputStream input2, Descriptors.FieldDescriptor fd, Message.Builder builder) throws IOException {
        builder.setField(fd, Protobufs.readFieldNoTag(input2, fd, builder));
    }

    public static Object readFieldNoTag(CodedInputStream input2, Descriptors.FieldDescriptor fd, Message.Builder enclosingBuilder) throws IOException {
        if (!fd.isRepeated()) {
            return Protobufs.readSingleFieldNoTag(input2, fd, enclosingBuilder);
        }
        ArrayList<Object> values2 = Lists.newArrayList();
        while (!input2.isAtEnd()) {
            values2.add(Protobufs.readSingleFieldNoTag(input2, fd, enclosingBuilder));
        }
        return values2;
    }

    private static Object readSingleFieldNoTag(CodedInputStream input2, Descriptors.FieldDescriptor fd, Message.Builder enclosingBuilder) throws IOException {
        switch (fd.getType()) {
            case DOUBLE: {
                return input2.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(input2.readFloat());
            }
            case INT64: 
            case UINT64: {
                return input2.readInt64();
            }
            case INT32: {
                return input2.readInt32();
            }
            case FIXED64: {
                return input2.readFixed64();
            }
            case FIXED32: {
                return input2.readFixed32();
            }
            case BOOL: {
                return input2.readBool();
            }
            case STRING: {
                return input2.readString();
            }
            case GROUP: 
            case MESSAGE: {
                Message.Builder fieldBuilder = enclosingBuilder.newBuilderForField(fd);
                input2.readMessage(fieldBuilder, null);
                return fieldBuilder.build();
            }
            case BYTES: {
                return input2.readBytes();
            }
            case UINT32: {
                return input2.readUInt32();
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor eVal = fd.getEnumType().findValueByNumber(input2.readEnum());
                return eVal != null ? eVal : fd.getDefaultValue();
            }
            case SFIXED32: {
                return input2.readSFixed32();
            }
            case SFIXED64: {
                return input2.readSFixed64();
            }
            case SINT32: {
                return input2.readSInt32();
            }
            case SINT64: {
                return input2.readSInt64();
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)fd.getType()) + " for " + fd.getFullName());
    }
}

