/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public final class PathFilters {
    public static final PathFilter EXCLUDE_HIDDEN_PATHS_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            String name2 = p.getName();
            return !name2.startsWith(".") && !name2.startsWith("_");
        }
    };
    public static final PathFilter ACCEPT_ALL_PATHS_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };

    private PathFilters() {
    }

    public static PathFilter newExcludeDirectoriesFilter(Configuration conf) {
        return new ExcludeDirectoriesOrFilesFilter(conf, ExcludeDirectoriesOrFilesFilter.Mode.EXCLUDE_DIRECTORIES);
    }

    public static PathFilter newExcludeFilesFilter(Configuration conf) {
        return new ExcludeDirectoriesOrFilesFilter(conf, ExcludeDirectoriesOrFilesFilter.Mode.EXCLUDE_FILES);
    }

    private static final class ExcludeDirectoriesOrFilesFilter
    extends Configured
    implements PathFilter {
        private Mode mode;

        private ExcludeDirectoriesOrFilesFilter() {
        }

        private ExcludeDirectoriesOrFilesFilter(Configuration conf) {
        }

        public ExcludeDirectoriesOrFilesFilter(Configuration conf, Mode mode2) {
            super(conf);
            this.mode = mode2;
        }

        public boolean accept(Path path) {
            try {
                FileSystem fs = path.getFileSystem(this.getConf());
                FileStatus fileStatus = fs.getFileStatus(path);
                if (this.mode == Mode.EXCLUDE_DIRECTORIES) {
                    return !fileStatus.isDir();
                }
                return fileStatus.isDir();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static enum Mode {
            EXCLUDE_DIRECTORIES,
            EXCLUDE_FILES;

        }
    }

    public static final class CompositePathFilter
    implements PathFilter {
        private PathFilter required;
        private PathFilter[] optional;

        public CompositePathFilter(PathFilter required, PathFilter ... optional) {
            this.required = required;
            this.optional = optional;
        }

        public boolean accept(Path path) {
            if (this.required.accept(path)) {
                for (PathFilter f2 : this.optional) {
                    if (f2.accept(path)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

