/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.hadoop.compression.lzo.LzopCodec;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LzoUtils.class);
    public static final String LZO_OUTPUT_INDEXABLE_MINSIZE = "elephantbird.lzo.output.indexable.minsize";
    public static final String LZO_OUTPUT_INDEX = "elephantbird.lzo.output.index";
    private static boolean isLzopIndexSupported = false;

    public static DataOutputStream getIndexedLzoOutputStream(Configuration conf, Path path) throws IOException {
        LzopCodec codec = new LzopCodec();
        codec.setConf(conf);
        final Path file = path;
        final FileSystem fs = file.getFileSystem(conf);
        FSDataOutputStream fileOut = fs.create(file, false);
        FSDataOutputStream indexOut = null;
        if (conf.getBoolean(LZO_OUTPUT_INDEX, false)) {
            if (isLzopIndexSupported) {
                Path indexPath = file.suffix(".index.tmp");
                indexOut = fs.create(indexPath, false);
            } else {
                LOG.warn("elephantbird.lzo.output.index is enabled, but LzopCodec does not have createIndexedOutputStream method. Please upgrade hadoop-lzo.");
            }
        }
        final boolean isIndexed = indexOut != null;
        final long minIndexableSize = conf.getLong(LZO_OUTPUT_INDEXABLE_MINSIZE, -1L);
        CompressionOutputStream out = isIndexed ? codec.createIndexedOutputStream((OutputStream)fileOut, (DataOutputStream)indexOut) : codec.createOutputStream((OutputStream)fileOut);
        return new DataOutputStream((OutputStream)out){

            @Override
            public void close() throws IOException {
                super.close();
                if (isIndexed) {
                    long minSizeToIndex;
                    Path tmpPath = file.suffix(".index.tmp");
                    FileStatus stat = fs.getFileStatus(file);
                    long l = minSizeToIndex = minIndexableSize < 0L ? stat.getBlockSize() : minIndexableSize;
                    if (stat.getLen() <= minSizeToIndex) {
                        fs.delete(tmpPath, false);
                    } else {
                        fs.rename(tmpPath, file.suffix(".index"));
                    }
                }
            }
        };
    }

    static {
        try {
            isLzopIndexSupported = null != LzopCodec.class.getMethod("createIndexedOutputStream", OutputStream.class, DataOutputStream.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

