/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');

    private HadoopUtils() {
    }

    public static Counter getCounter(JobContext ctx, String group2, String counter2) {
        Counter c;
        if (ctx instanceof TaskInputOutputContext && (c = HadoopCompat.getCounter((TaskInputOutputContext)ctx, group2, counter2)) != null) {
            return c;
        }
        String name2 = group2 + ":" + counter2;
        LOG.warn("Using a dummy counter for " + name2 + " because it does not already exist.");
        return HadoopCompat.newGenericCounter(name2, name2, 0L);
    }

    @Deprecated
    public static void setInputFormatClass(Configuration conf, String configKey, Class<?> clazz2) {
        HadoopUtils.setClassConf(conf, configKey, clazz2);
    }

    public static void setClassConf(Configuration conf, String configKey, Class<?> clazz2) {
        String existingClass = conf.get(configKey);
        String className = clazz2.getName();
        if (existingClass != null && !existingClass.equals(className)) {
            throw new RuntimeException("Already registered a different thriftClass for " + configKey + ". old: " + existingClass + " new: " + className);
        }
        conf.set(configKey, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToConfAsBase64(String key, Object obj, Configuration conf) throws IOException {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(obj);
        }
        catch (Throwable throwable2) {
            Closeables.close(oos, false);
            Closeables.close(gos, false);
            Closeables.close(baos, false);
            throw throwable2;
        }
        Closeables.close(oos, false);
        Closeables.close(gos, false);
        Closeables.close(baos, false);
        conf.set(key, new String(Base64.encodeBase64(baos.toByteArray()), Charsets.UTF_8));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObjectFromConfAsBase64(String key, Configuration conf) throws IOException {
        Object object;
        String b64 = conf.get(key);
        if (b64 == null) {
            return null;
        }
        byte[] bytes2 = Base64.decodeBase64(b64.getBytes(Charsets.UTF_8));
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes2);
            gis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gis);
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                LOG.error("Could not read object from config with key " + key, e);
                throw new IOException(e);
                catch (ClassCastException e2) {
                    LOG.error("Couldn't cast object read from config with key " + key, e2);
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable2) {
                Closeables.close(ois, false);
                Closeables.close(gis, false);
                Closeables.close(bais, false);
                throw throwable2;
            }
        }
        Closeables.close(ois, false);
        Closeables.close(gis, false);
        Closeables.close(bais, false);
        return (T)object;
    }

    public static void writeStringListToConfAsJson(String key, List<String> list2, Configuration conf) {
        Preconditions.checkNotNull(list2);
        conf.set(key, JSONArray.toJSONString(list2));
    }

    public static List<String> readStringListFromConfAsJson(String key, Configuration conf) {
        String json = conf.get(key);
        if (json == null) {
            return null;
        }
        return Lists.newArrayList((JSONArray)JSONValue.parse(json));
    }

    public static void writeStringListToConfAsBase64(String key, List<String> list2, Configuration conf) {
        Preconditions.checkNotNull(list2);
        Iterator<String> iter2 = list2.iterator();
        StringBuilder sb = new StringBuilder();
        while (iter2.hasNext()) {
            byte[] bytes2 = Base64.encodeBase64(iter2.next().getBytes(Charsets.UTF_8), false);
            sb.append(new String(bytes2, Charsets.UTF_8));
            if (!iter2.hasNext()) continue;
            sb.append(',');
        }
        conf.set(key, sb.toString());
    }

    public static List<String> readStringListFromConfAsBase64(String key, Configuration conf) {
        String b64List = conf.get(key);
        if (b64List == null) {
            return null;
        }
        ArrayList<String> strings = Lists.newArrayList();
        for (String b64 : COMMA_SPLITTER.split(b64List)) {
            byte[] bytes2 = Base64.decodeBase64(b64.getBytes(Charsets.UTF_8));
            strings.add(new String(bytes2, Charsets.UTF_8));
        }
        return strings;
    }
}

