/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.TaskHeartbeatThread;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecuteOnClusterTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteOnClusterTool.class);
    private static final String IMPL_KEY = ExecuteOnClusterTool.class.getName() + ".implclass";

    protected void setup(String[] args2, Configuration conf) throws IOException {
    }

    public abstract void execute(Mapper.Context var1) throws IOException;

    public int run(String[] args2) throws Exception {
        this.setup(args2, this.getConf());
        this.getConf().set(IMPL_KEY, ((Object)((Object)this)).getClass().getName());
        Job job = new Job(this.getConf());
        job.setInputFormatClass(DummyInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(ExecuteOnClusterMapper.class);
        job.setNumReduceTasks(0);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.submit();
        return job.waitForCompletion(true) ? 0 : -1;
    }

    private static final class DummyRecordReader
    extends RecordReader<NullWritable, NullWritable> {
        private boolean first = true;

        private DummyRecordReader() {
        }

        public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.first) {
                this.first = false;
                return true;
            }
            return false;
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public NullWritable getCurrentValue() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
        }
    }

    private static final class DummyInputFormat
    extends InputFormat<NullWritable, NullWritable> {
        private DummyInputFormat() {
        }

        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            return Lists.newArrayList(new InputSplit[]{new DummyInputSplit()});
        }

        public RecordReader<NullWritable, NullWritable> createRecordReader(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
            return new DummyRecordReader();
        }
    }

    private static final class DummyInputSplit
    extends InputSplit
    implements Writable {
        private DummyInputSplit() {
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }

    private static final class ExecuteOnClusterMapper
    extends Mapper<NullWritable, NullWritable, NullWritable, NullWritable> {
        private ExecuteOnClusterMapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void map(NullWritable key, NullWritable value2, Mapper.Context context) throws IOException, InterruptedException {
            ExecuteOnClusterTool tool;
            try {
                tool = (ExecuteOnClusterTool)((Object)Class.forName(HadoopCompat.getConfiguration((JobContext)context).get(IMPL_KEY)).newInstance());
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            TaskHeartbeatThread beat = new TaskHeartbeatThread((TaskAttemptContext)context){

                @Override
                protected void progress() {
                    LOG.info("Sending heartbeat");
                }
            };
            try {
                beat.start();
                tool.execute(context);
            }
            finally {
                beat.stop();
            }
        }
    }
}

