/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.twitter.elephantbird.util.ThriftUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;

public class TStructDescriptor {
    private static final Map<Class<?>, TStructDescriptor> structMap = Maps.newHashMap();
    private List<Field> fields;
    private Class<? extends TBase<?, ?>> tClass;
    private boolean isUnion;

    public Class<? extends TBase<?, ?>> getThriftClass() {
        return this.tClass;
    }

    public TBase<?, ?> newThriftObject() throws TException {
        try {
            return this.tClass.newInstance();
        }
        catch (Exception e) {
            throw new TException(e);
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field getFieldAt(int idx) {
        return this.fields.get(idx);
    }

    public Object getFieldValue(int fieldIdx, TBase tObject) {
        Field field2 = this.fields.get(fieldIdx);
        try {
            if (this.isUnion && field2.getFieldIdEnum() != ((TUnion)tObject).getSetField()) {
                return null;
            }
            return tObject.getFieldValue(field2.getFieldIdEnum());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TStructDescriptor getInstance(Class<? extends TBase<?, ?>> tClass) {
        Map<Class<?>, TStructDescriptor> map2 = structMap;
        synchronized (map2) {
            TStructDescriptor desc = structMap.get(tClass);
            if (desc == null) {
                desc = new TStructDescriptor();
                desc.tClass = tClass;
                structMap.put(tClass, desc);
                desc.build(tClass);
            }
            return desc;
        }
    }

    private TStructDescriptor() {
    }

    private void build(Class<? extends TBase<?, ?>> tClass) {
        Map<? extends TFieldIdEnum, FieldMetaData> fieldMap2 = FieldMetaData.getStructMetaDataMap(tClass);
        Field[] arr = new Field[fieldMap2.size()];
        this.isUnion = TUnion.class.isAssignableFrom(tClass);
        int idx = 0;
        for (Map.Entry<? extends TFieldIdEnum, FieldMetaData> e : fieldMap2.entrySet()) {
            String fieldName = e.getKey().getFieldName();
            arr[idx++] = new Field(e.getKey(), e.getValue(), fieldName, ThriftUtils.getFieldType(tClass, fieldName));
        }
        this.fields = ImmutableList.copyOf(arr);
    }

    private static Map<String, TEnum> extractEnumMap(Class<? extends TEnum> enumClass) {
        ImmutableMap.Builder<String, TEnum> builder = ImmutableMap.builder();
        for (TEnum e : enumClass.getEnumConstants()) {
            builder.put(e.toString(), e);
        }
        return builder.build();
    }

    private static byte getTTypeFromJavaType(Type jType) {
        Class klass;
        if (jType == Boolean.TYPE || jType == Boolean.class) {
            return 2;
        }
        if (jType == Byte.TYPE || jType == Byte.class) {
            return 3;
        }
        if (jType == Short.TYPE || jType == Short.class) {
            return 6;
        }
        if (jType == Integer.TYPE || jType == Integer.class) {
            return 8;
        }
        if (jType == Long.TYPE || jType == Long.class) {
            return 10;
        }
        if (jType == Double.TYPE || jType == Double.class) {
            return 4;
        }
        if (jType == String.class) {
            return 11;
        }
        if (jType == byte[].class) {
            return 11;
        }
        if (jType == Void.class) {
            return 1;
        }
        if (jType instanceof Class) {
            klass = (Class)jType;
            if (TEnum.class.isAssignableFrom(klass)) {
                return 16;
            }
            if (ByteBuffer.class.isAssignableFrom(klass)) {
                return 11;
            }
            if (TBase.class.isAssignableFrom(klass)) {
                return 12;
            }
        }
        if (jType instanceof ParameterizedType) {
            klass = (Class)((ParameterizedType)jType).getRawType();
            if (Map.class.isAssignableFrom(klass)) {
                return 13;
            }
            if (Set.class.isAssignableFrom(klass)) {
                return 14;
            }
            if (List.class.isAssignableFrom(klass)) {
                return 15;
            }
        }
        throw new IllegalArgumentException("cannot convert java type '" + jType + "'  to thrift type");
    }

    public static class Field {
        private final TFieldIdEnum fieldIdEnum;
        private final FieldMetaData fieldMetaData;
        private final short fieldId;
        private final String fieldName;
        private final byte ttype;
        private Field listElemField = null;
        private Field setElemField = null;
        private Field mapKeyField = null;
        private Field mapValueField = null;
        private Class<? extends TEnum> enumClass = null;
        private Map<String, TEnum> enumMap = null;
        private Map<Integer, TEnum> enumIdMap = null;
        private TStructDescriptor tStructDescriptor = null;
        private boolean isBuffer = false;

        private Field(TFieldIdEnum fieldIdEnum, FieldMetaData fieldMetaData, String fieldName, Type genericType) {
            this.fieldIdEnum = fieldIdEnum;
            this.fieldMetaData = fieldMetaData;
            this.fieldId = fieldIdEnum == null ? (short)1 : fieldIdEnum.getThriftFieldId();
            this.fieldName = fieldName;
            this.ttype = TStructDescriptor.getTTypeFromJavaType(genericType);
            Type firstTypeArg = null;
            Type secondTypeArg = null;
            if (genericType instanceof ParameterizedType) {
                Type[] typeArgs2 = ((ParameterizedType)genericType).getActualTypeArguments();
                firstTypeArg = typeArgs2.length > 0 ? typeArgs2[0] : null;
                secondTypeArg = typeArgs2.length > 1 ? typeArgs2[1] : null;
            }
            switch (this.ttype) {
                case 15: {
                    this.listElemField = new Field(null, null, fieldName + "_list_elem", firstTypeArg);
                    break;
                }
                case 13: {
                    this.mapKeyField = new Field(null, null, fieldName + "_map_key", firstTypeArg);
                    this.mapValueField = new Field(null, null, fieldName + "_map_value", secondTypeArg);
                    break;
                }
                case 14: {
                    this.setElemField = new Field(null, null, fieldName + "_set_elem", firstTypeArg);
                    break;
                }
                case 16: {
                    this.enumClass = (Class)genericType;
                    this.enumMap = TStructDescriptor.extractEnumMap(this.enumClass);
                    ImmutableMap.Builder<Integer, TEnum> builder = ImmutableMap.builder();
                    for (TEnum e : this.enumMap.values()) {
                        builder.put(e.getValue(), e);
                    }
                    this.enumIdMap = builder.build();
                    break;
                }
                case 12: {
                    this.tStructDescriptor = TStructDescriptor.getInstance((Class)genericType);
                    break;
                }
                case 11: {
                    this.isBuffer = !genericType.equals(String.class);
                    break;
                }
            }
        }

        public short getFieldId() {
            return this.fieldId;
        }

        public byte getType() {
            return this.ttype;
        }

        public TFieldIdEnum getFieldIdEnum() {
            return this.fieldIdEnum;
        }

        public boolean isBuffer() {
            return this.isBuffer;
        }

        public boolean isList() {
            return this.listElemField != null;
        }

        public Field getListElemField() {
            return this.listElemField;
        }

        public boolean isSet() {
            return this.setElemField != null;
        }

        public Field getSetElemField() {
            return this.setElemField;
        }

        public boolean isMap() {
            return this.mapKeyField != null;
        }

        public Field getMapKeyField() {
            return this.mapKeyField;
        }

        public Field getMapValueField() {
            return this.mapValueField;
        }

        public boolean isStruct() {
            return this.tStructDescriptor != null;
        }

        public TStructDescriptor gettStructDescriptor() {
            return this.tStructDescriptor;
        }

        public boolean isEnum() {
            return this.enumClass != null;
        }

        public Class<? extends TEnum> getEnumClass() {
            return this.enumClass;
        }

        public TEnum getEnumValueOf(String name2) {
            return this.enumMap == null ? null : this.enumMap.get(name2);
        }

        public TEnum getEnumValueOf(int id) {
            return this.enumIdMap == null ? null : this.enumIdMap.get(id);
        }

        public Collection<TEnum> getEnumValues() {
            return this.enumMap == null ? null : this.enumMap.values();
        }

        public String getName() {
            return this.fieldName;
        }

        public short getId() {
            return this.fieldId;
        }

        public FieldMetaData getFieldMetaData() {
            return this.fieldMetaData;
        }
    }
}

