/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.DecodeException;
import com.twitter.elephantbird.thrift.ThriftBinaryDeserializer;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConverter<M extends TBase<?, ?>>
implements BinaryConverter<M> {
    public static final Logger LOG = LoggerFactory.getLogger(ThriftConverter.class);
    private TypeRef<M> typeRef;
    private TSerializer serializer;
    private TDeserializer deserializer;
    private static final int MAX_WARNINGS = 100;
    private static int numWarningsLogged = 0;

    private static void logWarning(String message, Throwable t) {
        if (numWarningsLogged < 100) {
            LOG.info(message, t);
            ++numWarningsLogged;
        }
    }

    public static <M extends TBase<?, ?>> ThriftConverter<M> newInstance(Class<M> tClass) {
        return new ThriftConverter<M>(new TypeRef<M>(tClass){});
    }

    public static <M extends TBase<?, ?>> ThriftConverter<M> newInstance(TypeRef<M> typeRef) {
        return new ThriftConverter<M>(typeRef);
    }

    public ThriftConverter(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public M fromBytes(byte[] messageBuffer) throws DecodeException {
        try {
            if (this.deserializer == null) {
                this.deserializer = new ThriftBinaryDeserializer();
            }
            TBase message = (TBase)this.typeRef.safeNewInstance();
            this.deserializer.deserialize(message, messageBuffer);
            return (M)message;
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public byte[] toBytes(M message) {
        if (this.serializer == null) {
            this.serializer = new TSerializer();
        }
        try {
            return this.serializer.serialize((TBase)message);
        }
        catch (TException e) {
            ThriftConverter.logWarning("failed to serialize", e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        try {
            return this.typeRef.getType().equals(((ThriftConverter)obj).typeRef.getType());
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

