/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.DecodeException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryWritable<M>
implements WritableComparable<BinaryWritable<M>> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryWritable.class);
    private M message;
    private byte[] messageBytes;
    private BinaryConverter<M> converter;

    protected BinaryWritable(M message, BinaryConverter<M> converter2) {
        this.message = message;
        this.converter = converter2;
    }

    private void checkConverter() {
        if (this.converter == null) {
            throw new IllegalStateException("Runtime parameterized Protobuf/Thrift class is unkonwn. This object was probably created with default constructor. Please use setConverter(Class).");
        }
    }

    protected abstract BinaryConverter<M> getConverterFor(Class<M> var1);

    public void setConverter(Class<M> clazz2) {
        this.converter = this.getConverterFor(clazz2);
    }

    public void setConverter(BinaryConverter<M> converter2) {
        this.converter = converter2;
    }

    public M get() {
        if (this.message == null && this.messageBytes != null) {
            this.checkConverter();
            try {
                return this.converter.fromBytes(this.messageBytes);
            }
            catch (DecodeException e) {
                throw new IllegalStateException("Converter failed to deserialize", e);
            }
        }
        return this.message;
    }

    public void clear() {
        this.message = null;
        this.messageBytes = null;
    }

    public void set(M message) {
        this.message = message;
        this.messageBytes = null;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes2 = this.serialize();
        if (bytes2 != null) {
            out.writeInt(bytes2.length);
            out.write(bytes2, 0, bytes2.length);
        } else {
            out.writeInt(0);
        }
    }

    private byte[] serialize() {
        if (this.messageBytes == null && this.message != null) {
            this.checkConverter();
            this.messageBytes = this.converter.toBytes(this.message);
            if (this.messageBytes == null) {
                LOG.warn("Could not serialize " + this.message.getClass());
            } else {
                this.message = null;
            }
        }
        return this.messageBytes;
    }

    public void readFields(DataInput in) throws IOException {
        this.message = null;
        this.messageBytes = null;
        int size2 = in.readInt();
        if (size2 > 0) {
            byte[] buf = new byte[size2];
            in.readFully(buf, 0, size2);
            this.messageBytes = buf;
        }
    }

    public int compareTo(BinaryWritable<M> other) {
        byte[] thisBytes = this.serialize();
        byte[] otherBytes = super.serialize();
        int thisLen = thisBytes == null ? 0 : thisBytes.length;
        int otherLen = otherBytes == null ? 0 : otherBytes.length;
        return BytesWritable.Comparator.compareBytes((byte[])thisBytes, (int)0, (int)thisLen, (byte[])otherBytes, (int)0, (int)otherLen);
    }

    public boolean equals(Object obj) {
        BinaryWritable other;
        if (obj == null) {
            return false;
        }
        try {
            other = (BinaryWritable)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        byte[] bytes2 = this.serialize();
        return bytes2 == null ? 31 : Arrays.hashCode(bytes2);
    }

    public String toString() {
        Object msgObj = null;
        try {
            msgObj = this.get();
        }
        catch (IllegalStateException e) {
            return super.toString() + "{could not be deserialized}";
        }
        if (msgObj == null) {
            return super.toString();
        }
        return msgObj.toString();
    }
}

