/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;

public class LzoLineRecordReader
extends LzoRecordReader<LongWritable, Text>
implements MapredInputFormatCompatible<LongWritable, Text> {
    public static final String MAX_LINE_LEN_CONF = "elephantbird.line.recordreader.max.line.length";
    private LineReader in_;
    private LongWritable key_ = new LongWritable();
    private Text value_ = new Text();
    private int maxLineLen = Integer.MAX_VALUE;

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input2, Configuration conf) throws IOException {
        this.maxLineLen = conf.getInt(MAX_LINE_LEN_CONF, Integer.MAX_VALUE);
        this.in_ = new LineReader(input2, conf);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        if (!atFirstRecord) {
            this.in_.readLine(new Text(), this.maxLineLen);
        }
    }

    @Override
    public void setKeyValue(LongWritable key, Text value2) {
        this.key_ = key;
        this.value_ = value2;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int newSize = this.in_.readLine(this.value_, this.maxLineLen);
            if (newSize == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            return true;
        }
        return false;
    }
}

