/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.LineReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoJsonRecordReader
extends LzoRecordReader<LongWritable, MapWritable>
implements MapredInputFormatCompatible<LongWritable, MapWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoJsonRecordReader.class);
    private LineReader in_;
    private LongWritable key_ = new LongWritable();
    private MapWritable value_ = new MapWritable();
    private final Text currentLine_ = new Text();
    private final JSONParser jsonParser_ = new JSONParser();

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public MapWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input2, Configuration conf) throws IOException {
        this.in_ = new LineReader(input2, conf);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        if (!atFirstRecord) {
            this.in_.readLine(new Text());
        }
    }

    @Override
    public void setKeyValue(LongWritable key, MapWritable value2) {
        this.key_ = key;
        this.value_ = value2;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.value_.clear();
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int newSize = this.in_.readLine(this.currentLine_);
            if (newSize == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            if (!LzoJsonRecordReader.decodeLineToJson(this.jsonParser_, this.currentLine_, this.value_)) continue;
            return true;
        }
        return false;
    }

    public static boolean decodeLineToJson(JSONParser parser, Text line, MapWritable value2) {
        try {
            JSONObject jsonObj2 = (JSONObject)parser.parse(line.toString());
            if (jsonObj2 != null) {
                for (Object key : jsonObj2.keySet()) {
                    Text mapKey = new Text(key.toString());
                    Text mapValue = new Text();
                    if (jsonObj2.get(key) != null) {
                        mapValue.set(jsonObj2.get(key).toString());
                    }
                    value2.put((Writable)mapKey, (Writable)mapValue);
                }
            } else {
                LOG.warn("Could not json-decode string: " + line);
                return false;
            }
            return true;
        }
        catch (ParseException e) {
            LOG.warn("Could not json-decode string: " + line, e);
            return false;
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse field into number: " + line, e);
            return false;
        }
    }
}

