/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.Base64Codec;
import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.mapreduce.io.DecodeException;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.LineReader;

public class LzoBinaryB64LineRecordReader<M, W extends BinaryWritable<M>>
extends LzoRecordReader<LongWritable, W>
implements MapredInputFormatCompatible<LongWritable, W> {
    private LineReader lineReader_;
    private final Text line_ = new Text();
    private LongWritable key_ = new LongWritable();
    private W value_;
    private TypeRef<M> typeRef_;
    private int maxLineLen = Integer.MAX_VALUE;
    private final BinaryConverter<M> converter_;
    private Counter linesReadCounter;
    private Counter emptyLinesCounter;
    private Counter recordsReadCounter;
    private Counter recordErrorsCounter;
    private Counter truncatedLinesCounter;
    private Counter recordsSkippedCounter;

    protected LzoBinaryB64LineRecordReader(TypeRef<M> typeRef, W protobufWritable, BinaryConverter<M> protoConverter) {
        this.typeRef_ = typeRef;
        this.converter_ = protoConverter;
        this.value_ = protobufWritable;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.lineReader_ != null) {
            this.lineReader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public W getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input2, Configuration conf) throws IOException {
        this.maxLineLen = conf.getInt("elephantbird.line.recordreader.max.line.length", Integer.MAX_VALUE);
        this.lineReader_ = new LineReader(input2, conf);
    }

    @Override
    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        String group2 = "LzoB64Lines of " + this.typeRef_.getRawClass().getName();
        this.linesReadCounter = HadoopUtils.getCounter((JobContext)context, group2, "Lines Read");
        this.recordsReadCounter = HadoopUtils.getCounter((JobContext)context, group2, "Records Read");
        this.recordErrorsCounter = HadoopUtils.getCounter((JobContext)context, group2, "Errors");
        this.emptyLinesCounter = HadoopUtils.getCounter((JobContext)context, group2, "Empty Lines");
        this.truncatedLinesCounter = HadoopUtils.getCounter((JobContext)context, group2, "Truncated Lines");
        this.recordsSkippedCounter = HadoopUtils.getCounter((JobContext)context, group2, "Records Skipped by Converter");
        super.initialize(genericSplit, context);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        if (!atFirstRecord) {
            this.lineReader_.readLine(new Text(), this.maxLineLen);
        }
    }

    @Override
    public void setKeyValue(LongWritable key, W value2) {
        this.key_ = key;
        this.value_ = value2;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int newSize = this.lineReader_.readLine(this.line_, this.maxLineLen);
            if (newSize == 0) {
                return false;
            }
            HadoopCompat.incrementCounter(this.linesReadCounter, 1L);
            this.pos_ = this.getLzoFilePos();
            if (this.line_.getLength() == 0 || this.line_.charAt(0) == 10) {
                HadoopCompat.incrementCounter(this.emptyLinesCounter, 1L);
                continue;
            }
            if (this.line_.getLength() >= this.maxLineLen) {
                HadoopCompat.incrementCounter(this.truncatedLinesCounter, 1L);
            }
            Object protoValue = null;
            this.errorTracker.incRecords();
            try {
                protoValue = this.converter_.fromBytes(Base64Codec.decodeFast(this.line_.getBytes(), this.line_.getLength()));
            }
            catch (DecodeException t1) {
                HadoopCompat.incrementCounter(this.recordErrorsCounter, 1L);
                this.errorTracker.incErrors(t1);
            }
            if (protoValue == null) {
                HadoopCompat.incrementCounter(this.recordsSkippedCounter, 1L);
                continue;
            }
            HadoopCompat.incrementCounter(this.recordsReadCounter, 1L);
            ((BinaryWritable)this.value_).set(protoValue);
            return true;
        }
        return false;
    }
}

