/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.IntegerListInputSplit;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class IntegerListRecordReader
extends RecordReader<LongWritable, NullWritable> {
    private static final Log LOG = LogFactory.getLog(IntegerListRecordReader.class);
    protected LongWritable key = new LongWritable();
    protected IntegerListInputSplit split;
    protected long cur;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.split = (IntegerListInputSplit)inputSplit;
        this.cur = this.split.getMin() - 1L;
        LOG.info("Creating IntegerListRecordReader with InputSplit [" + this.split.getMin() + ", " + this.split.getMax() + "]");
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        ++this.cur;
        this.key.set(this.cur);
        return this.cur <= this.split.getMax();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public NullWritable getCurrentValue() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)(this.cur - this.split.getMin() + 1L) / (float)this.split.getLength();
    }

    public void close() throws IOException {
    }
}

