/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.output;

import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapreduce.output.WorkFileOverride;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class DeprecatedOutputFormatWrapper<K, V>
implements org.apache.hadoop.mapred.OutputFormat<K, V> {
    protected OutputFormat<K, V> realOutputFormat;
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.DeprecatedOutputFormatWrapper";

    public DeprecatedOutputFormatWrapper() {
    }

    public DeprecatedOutputFormatWrapper(OutputFormat<K, V> mapreduceOutputFormat) {
        this.realOutputFormat = mapreduceOutputFormat;
    }

    public static void setOutputFormat(Class<?> realOutputFormatClass, JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedOutputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, realOutputFormatClass);
    }

    private void initOutputFormat(JobConf conf) {
        if (this.realOutputFormat == null) {
            this.realOutputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)conf.getClass(CLASS_CONF_KEY, null, OutputFormat.class), (Configuration)conf);
        }
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.initOutputFormat(job);
        try {
            this.realOutputFormat.checkOutputSpecs(HadoopCompat.newJobContext((Configuration)job, null));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public org.apache.hadoop.mapred.RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name2, Progressable progress) throws IOException {
        this.initOutputFormat(job);
        if (this.realOutputFormat instanceof WorkFileOverride) {
            ((WorkFileOverride)this.realOutputFormat).setName(name2);
        }
        return new RecordWriterWrapper<K, V>(this.realOutputFormat, job, name2, progress);
    }

    private static class RecordWriterWrapper<K, V>
    implements org.apache.hadoop.mapred.RecordWriter<K, V> {
        private RecordWriter<K, V> realWriter;
        private TaskAttemptContext taskContext;

        RecordWriterWrapper(OutputFormat<K, V> realOutputFormat, JobConf jobConf, String name2, Progressable progress) throws IOException {
            try {
                this.taskContext = HadoopCompat.newMapContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id")), null, null, null, new DeprecatedInputFormatWrapper.ReporterWrapper((Reporter)progress), null);
                this.realWriter = realOutputFormat.getRecordWriter(this.taskContext);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void close(Reporter reporter) throws IOException {
            try {
                this.realWriter.close(this.taskContext);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void write(K key, V value2) throws IOException {
            try {
                this.realWriter.write(key, value2);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

