/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import com.google.protobuf.Message;
import com.twitter.elephantbird.cascading2.scheme.LzoBinaryScheme;
import com.twitter.elephantbird.mapred.output.DeprecatedOutputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.input.combine.DelegateCombineFileInputFormat;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.LzoProtobufBlockOutputFormat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class LzoProtobufScheme<M extends Message>
extends LzoBinaryScheme<M, ProtobufWritable<M>> {
    private static final long serialVersionUID = -5011096855302946105L;
    private Class protoClass;

    public LzoProtobufScheme(Class protoClass) {
        this.protoClass = protoClass;
    }

    @Override
    protected ProtobufWritable<M> prepareBinaryWritable() {
        TypeRef typeRef = Protobufs.getTypeRef(this.protoClass.getName());
        return new ProtobufWritable(typeRef);
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> hfp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        LzoProtobufBlockOutputFormat.setClassConf(this.protoClass, (Configuration)conf);
        DeprecatedOutputFormatWrapper.setOutputFormat(LzoProtobufBlockOutputFormat.class, conf);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> hfp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        MultiInputFormat.setClassConf(this.protoClass, (Configuration)conf);
        DelegateCombineFileInputFormat.setDelegateInputFormat(conf, MultiInputFormat.class);
    }
}

