/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.io.protobuf;

import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.io.BufferedInputStream;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;

public class ProtobufComparator
implements StreamComparator<BufferedInputStream>,
Comparator<Message> {
    private static final int BUFFER_SIZE = 1024;
    private byte[] buffer = new byte[1024];
    private NoCopyByteArrayOutputStream leftBos = new NoCopyByteArrayOutputStream();
    private NoCopyByteArrayOutputStream rightBos = new NoCopyByteArrayOutputStream();

    @Override
    public int compare(BufferedInputStream leftStream, BufferedInputStream rightStream) {
        this.leftBos.reset();
        this.rightBos.reset();
        ProtobufComparator.readFully(leftStream, this.leftBos, this.buffer);
        ProtobufComparator.readFully(rightStream, this.rightBos, this.buffer);
        return ProtobufComparator.compareByteArrays(this.leftBos, this.rightBos);
    }

    @Override
    public int compare(Message left3, Message right) {
        try {
            this.leftBos.reset();
            this.rightBos.reset();
            left3.writeTo(this.leftBos);
            right.writeTo(this.rightBos);
            return ProtobufComparator.compareByteArrays(this.leftBos, this.rightBos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readFully(InputStream in, ByteArrayOutputStream out, byte[] buffer2) {
        try {
            int numRead = 0;
            while ((numRead = in.read(buffer2, 0, buffer2.length)) != -1) {
                out.write(buffer2, 0, numRead);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int compareByteArrays(NoCopyByteArrayOutputStream leftBos, NoCopyByteArrayOutputStream rightBos) {
        int rightCount;
        byte[] left3 = leftBos.getByteArray();
        byte[] right = rightBos.getByteArray();
        int leftCount = leftBos.getCount();
        if (leftCount != (rightCount = rightBos.getCount())) {
            return leftCount - rightCount;
        }
        for (int i = 0; i < leftCount; ++i) {
            if (left3[i] == right[i]) continue;
            return left3[i] - right[i];
        }
        return 0;
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private NoCopyByteArrayOutputStream() {
        }

        public byte[] getByteArray() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

