/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.java;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.chill.IKryoRegistrar;
import com.twitter.chill.SingleRegistrar;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class ArraysAsListSerializer
extends Serializer<List<?>> {
    private Field _arrayField;

    public static IKryoRegistrar registrar() {
        return new SingleRegistrar(Arrays.asList("").getClass(), new ArraysAsListSerializer());
    }

    public ArraysAsListSerializer() {
        try {
            this._arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
            this._arrayField.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public List<?> read(Kryo kryo, Input input2, Class<List<?>> clazz2) {
        int n = input2.readInt(true);
        Class clazz3 = kryo.readClass(input2).getType();
        try {
            Object[] objectArray = (Object[])Array.newInstance(clazz3, n);
            for (int i = 0; i < n; ++i) {
                objectArray[i] = kryo.readClassAndObject(input2);
            }
            return Arrays.asList(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void write(Kryo kryo, Output output, List<?> list2) {
        try {
            Object[] objectArray = (Object[])this._arrayField.get(list2);
            output.writeInt(objectArray.length, true);
            Class<?> clazz2 = objectArray.getClass().getComponentType();
            kryo.writeClass(output, clazz2);
            for (Object object : objectArray) {
                kryo.writeClassAndObject(output, object);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

