/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.hadoop;

import com.twitter.chill.KryoPool;
import com.twitter.chill.SerDeState;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Serializer;

public class KryoSerializer
implements Serializer<Object> {
    private final KryoPool kryoPool;
    private DataOutputStream outputStream;

    public KryoSerializer(KryoPool kryoPool) {
        this.kryoPool = kryoPool;
    }

    public void open(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    public void serialize(Object object) throws IOException {
        SerDeState serDeState = (SerDeState)this.kryoPool.borrow();
        try {
            serDeState.writeObject(object);
            this.outputStream.writeInt(serDeState.numOfWrittenBytes());
            serDeState.writeOutputTo(this.outputStream);
        }
        finally {
            this.kryoPool.release(serDeState);
        }
        this.outputStream.flush();
    }

    public void close() throws IOException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.outputStream = null;
        }
    }
}

