/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.KryoPool;
import com.twitter.chill.config.ConfigurationException;
import com.twitter.chill.config.ConfiguredInstantiator;
import com.twitter.chill.hadoop.HadoopConfig;
import com.twitter.chill.hadoop.KryoDeserializer;
import com.twitter.chill.hadoop.KryoSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class KryoSerialization
extends Configured
implements Serialization<Object> {
    KryoPool kryoPool;
    Kryo testKryo;
    protected static int GUESS_THREADS_PER_CORE = 4;
    protected static int MAX_CACHED_KRYO = GUESS_THREADS_PER_CORE * Runtime.getRuntime().availableProcessors();

    public KryoSerialization() {
    }

    public KryoSerialization(Configuration configuration) {
        super(configuration);
    }

    public void setConf(Configuration configuration) {
        if (configuration != null) {
            try {
                ConfiguredInstantiator configuredInstantiator = new ConfiguredInstantiator(new HadoopConfig(configuration));
                this.testKryo = ((KryoInstantiator)configuredInstantiator).newKryo();
                this.kryoPool = KryoPool.withByteArrayOutputStream(MAX_CACHED_KRYO, configuredInstantiator);
            }
            catch (ConfigurationException configurationException) {
                throw new RuntimeException(configurationException);
            }
        }
    }

    public boolean accept(Class<?> clazz2) {
        try {
            return this.testKryo.getRegistration(clazz2) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public Serializer<Object> getSerializer(Class<Object> clazz2) {
        return new KryoSerializer(this.kryoPool);
    }

    public Deserializer<Object> getDeserializer(Class<Object> clazz2) {
        return new KryoDeserializer(this.kryoPool, clazz2);
    }
}

