/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.ResourcePool;
import com.twitter.chill.SerDeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class KryoPool
extends ResourcePool<SerDeState> {
    protected KryoPool(int n) {
        super(n);
    }

    @Override
    public void release(SerDeState serDeState) {
        serDeState.clear();
        super.release(serDeState);
    }

    public static KryoPool withBuffer(int n, final KryoInstantiator kryoInstantiator, final int n2, final int n3) {
        return new KryoPool(n){

            @Override
            protected SerDeState newInstance() {
                return new SerDeState(kryoInstantiator.newKryo(), new Input(), new Output(n2, n3));
            }
        };
    }

    public static KryoPool withByteArrayOutputStream(int n, final KryoInstantiator kryoInstantiator) {
        return new KryoPool(n){

            @Override
            protected SerDeState newInstance() {
                return new SerDeState(kryoInstantiator.newKryo(), new Input(), new Output(new ByteArrayOutputStream())){

                    @Override
                    public void clear() {
                        super.clear();
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output.getOutputStream();
                        byteArrayOutputStream.reset();
                    }

                    @Override
                    public byte[] outputToBytes() {
                        this.output.flush();
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output.getOutputStream();
                        return byteArrayOutputStream.toByteArray();
                    }

                    @Override
                    public void writeOutputTo(OutputStream outputStream) throws IOException {
                        this.output.flush();
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output.getOutputStream();
                        byteArrayOutputStream.writeTo(outputStream);
                    }
                };
            }
        };
    }

    public <T> T deepCopy(T t) {
        return (T)this.fromBytes(this.toBytesWithoutClass(t), t.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromBytes(byte[] byArray) {
        SerDeState serDeState = (SerDeState)this.borrow();
        try {
            serDeState.setInput(byArray);
            Object object = serDeState.readClassAndObject();
            return object;
        }
        finally {
            this.release(serDeState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromBytes(byte[] byArray, Class<T> clazz2) {
        SerDeState serDeState = (SerDeState)this.borrow();
        try {
            serDeState.setInput(byArray);
            T t = serDeState.readObject(clazz2);
            return t;
        }
        finally {
            this.release(serDeState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytesWithClass(Object object) {
        SerDeState serDeState = (SerDeState)this.borrow();
        try {
            serDeState.writeClassAndObject(object);
            byte[] byArray = serDeState.outputToBytes();
            return byArray;
        }
        finally {
            this.release(serDeState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytesWithoutClass(Object object) {
        SerDeState serDeState = (SerDeState)this.borrow();
        try {
            serDeState.writeObject(object);
            byte[] byArray = serDeState.outputToBytes();
            return byArray;
        }
        finally {
            this.release(serDeState);
        }
    }
}

