/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird.matrix;

import com.twitter.algebird.AdaptiveVector;
import com.twitter.algebird.Monoid;
import com.twitter.algebird.matrix.AdaptiveMatrix;
import com.twitter.algebird.matrix.DenseMatrix;
import com.twitter.algebird.matrix.SparseColumnMatrix$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005q!B\u0001\u0003\u0011\u0003Y\u0011AE*qCJ\u001cXmQ8mk6tW*\u0019;sSbT!a\u0001\u0003\u0002\r5\fGO]5y\u0015\t)a!\u0001\u0005bY\u001e,'-\u001b:e\u0015\t9\u0001\"A\u0004uo&$H/\u001a:\u000b\u0003%\t1aY8n\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011!c\u00159beN,7i\u001c7v[:l\u0015\r\u001e:jqN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006;5!\tAH\u0001\u000bMJ|WnU3r\u001b\u0006\u0004XcA\u0010\u0002*R)\u0001%!-\u00024R\u0019\u0011%a+\u0011\t1\u0011\u0013q\u0015\u0004\u0005\u001d\t\u00015%\u0006\u0002%UM!!%J\u001a\u0017!\raa\u0005K\u0005\u0003O\t\u0011a\"\u00113baRLg/Z'biJL\u0007\u0010\u0005\u0002*U1\u0001A!B\u0016#\u0005\u0004a#!\u0001,\u0012\u00055\u0002\u0004CA\t/\u0013\ty#CA\u0004O_RD\u0017N\\4\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u0005\r\te.\u001f\t\u0003#QJ!!\u000e\n\u0003\u000fA\u0013x\u000eZ;di\"AqG\tBK\u0002\u0013\u0005\u0001(A\u0007s_^\u001c()_\"pYVlgn]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000b\u0003\u0019a$o\\8u}%\t1#\u0003\u0002B%\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0003\u0003J\u00012AR$)\u001b\u0005!\u0011B\u0001%\u0005\u00059\tE-\u00199uSZ,g+Z2u_JD\u0001B\u0013\u0012\u0003\u0012\u0003\u0006I!O\u0001\u000fe><8OQ=D_2,XN\\:!\u0011!a%EaA!\u0002\u0017i\u0015AC3wS\u0012,gnY3%eA\u0019aI\u0014\u0015\n\u0005=#!AB'p]>LG\rC\u0003\u001bE\u0011\u0005\u0011\u000b\u0006\u0002S+R\u00111\u000b\u0016\t\u0004\u0019\tB\u0003\"\u0002'Q\u0001\bi\u0005\"B\u001cQ\u0001\u0004I\u0004bB,#\u0005\u0004%\t\u0001W\u0001\fm\u0006dW/Z'p]>LG-F\u0001N\u0011\u0019Q&\u0005)A\u0005\u001b\u0006aa/\u00197vK6{gn\\5eA!)AL\tC!;\u0006!!o\\<t+\u0005q\u0006CA\t`\u0013\t\u0001'CA\u0002J]RDQA\u0019\u0012\u0005Bu\u000bAaY8mg\")AM\tC\u0001K\u0006Aq-\u001a;WC2,X\r\u0006\u0002)M\")qm\u0019a\u0001Q\u0006A\u0001o\\:ji&|g\u000e\u0005\u0003\u0012Szs\u0016B\u00016\u0013\u0005\u0019!V\u000f\u001d7fe!)AN\tC\u0001[\u00069Q\u000f\u001d3bi\u0016$GcA*o_\")qm\u001ba\u0001Q\")\u0001o\u001ba\u0001Q\u0005)a/\u00197vK\")!O\tC!g\u0006QQ\u000f\u001d3bi\u0016Le\u000e^8\u0015\u0005Q<\bCA\tv\u0013\t1(C\u0001\u0003V]&$\b\"\u0002=r\u0001\u0004I\u0018A\u00022vM\u001a,'\u000fE\u0002{\u007f\"j\u0011a\u001f\u0006\u0003yv\fq!\\;uC\ndWM\u0003\u0002\u007f%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\u00051PA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bbBA\u0003E\u0011\u0005\u0011qA\u0001\bi>$UM\\:f+\t\tI\u0001\u0005\u0003\r\u0003\u0017A\u0013bAA\u0007\u0005\tYA)\u001a8tK6\u000bGO]5y\u0011\u001d\t\tB\tC!\u0003'\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e9\u0019\u0011#!\u0007\n\u0007\u0005m!#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037\u0011\u0002\"CA\u0013E\u0005\u0005I\u0011AA\u0014\u0003\u0011\u0019w\u000e]=\u0016\t\u0005%\u0012\u0011\u0007\u000b\u0005\u0003W\t9\u0004\u0006\u0003\u0002.\u0005M\u0002\u0003\u0002\u0007#\u0003_\u00012!KA\u0019\t\u0019Y\u00131\u0005b\u0001Y!9A*a\tA\u0004\u0005U\u0002\u0003\u0002$O\u0003_A\u0011bNA\u0012!\u0003\u0005\r!!\u000f\u0011\ti\u0012\u00151\b\t\u0005\r\u001e\u000by\u0003C\u0005\u0002@\t\n\n\u0011\"\u0001\u0002B\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BA\"\u00033*\"!!\u0012+\u0007e\n9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019FE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019Y\u0013Q\bb\u0001Y!I\u0011Q\f\u0012\u0002\u0002\u0013\u0005\u0013qL\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003[j!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0005Y\u0006twM\u0003\u0002\u0002l\u0005!!.\u0019<b\u0013\u0011\ty\"!\u001a\t\u0011\u0005E$%!A\u0005\u0002u\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"!\u001e#\u0003\u0003%\t!a\u001e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001'!\u001f\t\u0013\u0005m\u00141OA\u0001\u0002\u0004q\u0016a\u0001=%c!I\u0011q\u0010\u0012\u0002\u0002\u0013\u0005\u0013\u0011Q\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0011\t\u0006\u0003\u000b\u000b9\tM\u0007\u0002{&\u0019\u0011\u0011R?\u0003\u0011%#XM]1u_JD\u0011\"!$#\u0003\u0003%\t!a$\u0002\u0011\r\fg.R9vC2$B!!%\u0002\u0018B\u0019\u0011#a%\n\u0007\u0005U%CA\u0004C_>dW-\u00198\t\u0013\u0005m\u00141RA\u0001\u0002\u0004\u0001\u0004\"CANE\u0005\u0005I\u0011IAO\u0003!A\u0017m\u001d5D_\u0012,G#\u00010\t\u0013\u0005\u0005&%!A\u0005B\u0005\r\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0012\u0006\u0015\u0006\"CA>\u0003?\u000b\t\u00111\u00011!\rI\u0013\u0011\u0016\u0003\u0006Wq\u0011\r\u0001\f\u0005\n\u0003[c\u0012\u0011!a\u0002\u0003_\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\u00111e*a*\t\u000b\td\u0002\u0019\u00010\t\u000f\u0005UF\u00041\u0001\u00028\u0006!A-\u0019;b!\u0011Q$)!/\u0011\ri\fYLXAT\u0013\r\til\u001f\u0002\u0004\u001b\u0006\u0004\b\"CAa\u001b\u0005\u0005I\u0011QAb\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\t)-!4\u0015\t\u0005\u001d\u00171\u001b\u000b\u0005\u0003\u0013\fy\r\u0005\u0003\rE\u0005-\u0007cA\u0015\u0002N\u001211&a0C\u00021Bq\u0001TA`\u0001\b\t\t\u000e\u0005\u0003G\u001d\u0006-\u0007bB\u001c\u0002@\u0002\u0007\u0011Q\u001b\t\u0005u\t\u000b9\u000e\u0005\u0003G\u000f\u0006-\u0007\"CAn\u001b\u0005\u0005I\u0011QAo\u0003\u001d)h.\u00199qYf,B!a8\u0002nR!\u0011\u0011]Ax!\u0015\t\u00121]At\u0013\r\t)O\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ti\u0012\u0015\u0011\u001e\t\u0005\r\u001e\u000bY\u000fE\u0002*\u0003[$aaKAm\u0005\u0004a\u0003BCAy\u00033\f\t\u00111\u0001\u0002t\u0006\u0019\u0001\u0010\n\u0019\u0011\t1\u0011\u00131\u001e\u0005\n\u0003ol\u0011\u0011!C\u0005\u0003s\f1B]3bIJ+7o\u001c7wKR\u0011\u00111 \t\u0005\u0003G\ni0\u0003\u0003\u0002\u0000\u0006\u0015$AB(cU\u0016\u001cG\u000f")
public class SparseColumnMatrix<V>
extends AdaptiveMatrix<V>
implements Product,
Serializable {
    private final IndexedSeq<AdaptiveVector<V>> rowsByColumns;
    private final Monoid<V> evidence$2;
    private final Monoid<V> valueMonoid;

    public static <V> SparseColumnMatrix<V> fromSeqMap(int n, IndexedSeq<Map<Object, V>> indexedSeq, Monoid<V> monoid2) {
        return SparseColumnMatrix$.MODULE$.fromSeqMap(n, indexedSeq, monoid2);
    }

    public IndexedSeq<AdaptiveVector<V>> rowsByColumns() {
        return this.rowsByColumns;
    }

    public Monoid<V> valueMonoid() {
        return this.valueMonoid;
    }

    @Override
    public int rows() {
        return this.rowsByColumns().size();
    }

    @Override
    public int cols() {
        return ((SeqLike)this.rowsByColumns().apply(false)).size();
    }

    @Override
    public V getValue(Tuple2<Object, Object> position2) {
        return ((AdaptiveVector)this.rowsByColumns().apply(position2._1$mcI$sp())).apply(position2._2$mcI$sp());
    }

    @Override
    public SparseColumnMatrix<V> updated(Tuple2<Object, Object> position2, V value2) {
        if (position2 != null) {
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(position2._1$mcI$sp(), position2._2$mcI$sp());
            int row = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
            int col = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
            return new SparseColumnMatrix<V>(this.rowsByColumns().updated(row, ((AdaptiveVector)this.rowsByColumns().apply(row)).updated(col, value2), IndexedSeq$.MODULE$.canBuildFrom()), this.evidence$2);
        }
        throw new MatchError(position2);
    }

    @Override
    public void updateInto(ArrayBuffer<V> buffer2) {
        int lcols = this.cols();
        for (int row = 0; row < this.rows(); ++row) {
            Iterator iter2 = ((AdaptiveVector)this.rowsByColumns().apply(row)).denseIterator();
            while (iter2.hasNext()) {
                Tuple2 tuple2 = iter2.next();
                if (tuple2 != null) {
                    Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToInteger(tuple2._1$mcI$sp()), tuple2._2());
                    int col = tuple22._1$mcI$sp();
                    Object value2 = tuple22._2();
                    int indx = row * lcols + col;
                    buffer2.update(indx, this.valueMonoid().plus(buffer2.apply(indx), value2));
                    continue;
                }
                throw new MatchError(tuple2);
            }
        }
    }

    public DenseMatrix<V> toDense() {
        ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(this.size(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseColumnMatrix $outer;

            public final V apply() {
                return this.$outer.valueMonoid().zero();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.updateInto(buf);
        return new DenseMatrix<V>(this.rows(), this.cols(), buf, this.evidence$2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Predef$ predef$ = Predef$.MODULE$;
        builder.$plus$plus$eq(new StringOps("Row: %d, Cols: %d. Dense elements:\n").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.rows()), BoxesRunTime.boxToInteger(this.cols())})));
        this.rowsByColumns().foreach(new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;

            public final StringBuilder apply(AdaptiveVector<V> v) {
                this.builder$1.$plus$plus$eq(v.denseIterator().toList().toString());
                return this.builder$1.$plus$plus$eq("\n");
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    public <V> SparseColumnMatrix<V> copy(IndexedSeq<AdaptiveVector<V>> rowsByColumns, Monoid<V> evidence$2) {
        return new SparseColumnMatrix<V>(rowsByColumns, evidence$2);
    }

    public <V> IndexedSeq<AdaptiveVector<V>> copy$default$1() {
        return this.rowsByColumns();
    }

    @Override
    public String productPrefix() {
        return "SparseColumnMatrix";
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public Object productElement(int x$1) {
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
            case 0: 
        }
        return this.rowsByColumns();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof SparseColumnMatrix;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof SparseColumnMatrix)) return false;
        boolean bl = true;
        if (!bl) return false;
        SparseColumnMatrix sparseColumnMatrix = (SparseColumnMatrix)x$1;
        IndexedSeq<AdaptiveVector<V>> indexedSeq = this.rowsByColumns();
        IndexedSeq<AdaptiveVector<V>> indexedSeq2 = sparseColumnMatrix.rowsByColumns();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        if (!sparseColumnMatrix.canEqual(this)) return false;
        return true;
    }

    public SparseColumnMatrix(IndexedSeq<AdaptiveVector<V>> rowsByColumns, Monoid<V> evidence$2) {
        this.rowsByColumns = rowsByColumns;
        this.evidence$2 = evidence$2;
        super(evidence$2);
        Product$class.$init$(this);
        Predef$ predef$ = Predef$.MODULE$;
        this.valueMonoid = evidence$2;
    }
}

