/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird.javaapi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class MethodRegistry {
    private final Map<Class<?>, Method> classToMethod = new HashMap();
    private final Object provider;
    private final Class<?> provided;

    MethodRegistry(Object object, Class<?> clazz2) {
        this.provider = object;
        this.provided = clazz2;
        Object[] objectArray = clazz2.getTypeParameters();
        if (objectArray == null || objectArray.length != 1) {
            throw new IllegalArgumentException("provided must have exactly one type parameter. Found: " + Arrays.toString(objectArray));
        }
        Class<?> clazz3 = object.getClass();
        HashSet<Class> hashSet = new HashSet<Class>();
        for (Method method : clazz3.getMethods()) {
            Type type;
            Class clazz4;
            Type type2;
            if (method.getParameterTypes().length != 0 || !method.getReturnType().isAssignableFrom(clazz2) || !((type2 = method.getGenericReturnType()) instanceof ParameterizedType) || (clazz4 = (type = ((ParameterizedType)type2).getActualTypeArguments()[0]) instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type) == Object.class || hashSet.contains(clazz4) || this.classToMethod.put(clazz4, method) == null) continue;
            this.classToMethod.remove(clazz4);
            hashSet.add(clazz4);
        }
    }

    private Method getMethod(Class<?> clazz2) {
        Method method = this.classToMethod.get(clazz2);
        if (method == null && clazz2.getSuperclass() != null) {
            return this.getMethod(clazz2.getSuperclass());
        }
        return method;
    }

    private String typeName(Class<?> clazz2) {
        return this.provided.getSimpleName() + "<" + clazz2 + ">";
    }

    Object resolveAndInvoke(Class<?> clazz2) {
        Method method = this.getMethod(clazz2);
        if (method != null) {
            try {
                return method.invoke(this.provider, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not resolve " + this.typeName(clazz2) + " because " + method.getName() + "() threw an exception", invocationTargetException.getTargetException());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Should not happen. Could not resolve " + this.typeName(clazz2) + " because " + method.getName() + "() is not accessible", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Should not happen. Could not call " + method.getName() + " on provider object", illegalArgumentException);
            }
        }
        throw new IllegalArgumentException(this.typeName(clazz2) + " not found");
    }
}

