/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.BitSetLite;
import com.twitter.algebird.Bytes;
import com.twitter.algebird.DenseHLL;
import com.twitter.algebird.HLL;
import com.twitter.algebird.Hash128$;
import com.twitter.algebird.HyperLogLog$;
import com.twitter.algebird.Max;
import com.twitter.algebird.SparseHLL;
import java.nio.ByteBuffer;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class HyperLogLog$ {
    public static final HyperLogLog$ MODULE$;
    private final int hashSize;
    private final double[] negativePowersOfTwo;

    static {
        new HyperLogLog$();
    }

    public int hashSize() {
        return this.hashSize;
    }

    public double[] negativePowersOfTwo() {
        return this.negativePowersOfTwo;
    }

    public byte[] hash(byte[] input2) {
        Tuple2<Object, Object> tuple2 = Hash128$.MODULE$.arrayByteHash().hash(input2);
        if (tuple2 != null) {
            Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(tuple2._1$mcJ$sp(), tuple2._2$mcJ$sp());
            long l0 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
            long l1 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
            return this.pairLongs2Bytes(l0, l1);
        }
        throw new MatchError(tuple2);
    }

    public byte[] pairLongs2Bytes(long l0, long l1) {
        byte[] buf = new byte[16];
        ByteBuffer.wrap(buf).putLong(l0).putLong(l1);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] int2Bytes(int i) {
        void var2_2;
        byte[] buf = new byte[4];
        ByteBuffer.wrap(buf).putInt(i);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] long2Bytes(long i) {
        void var3_2;
        byte[] buf = new byte[8];
        ByteBuffer.wrap(buf).putLong(i);
        return var3_2;
    }

    public double twopow(int i) {
        return Math.pow(2.0, i);
    }

    public int j(BitSetLite bsl, int bits2) {
        return this.loop$1(0, 0, bsl, bits2);
    }

    public byte rhoW(BitSetLite bsl, int bits2) {
        return (byte)this.loop$2(bits2, 1, bsl);
    }

    public Tuple2<Object, Object> jRhoW(byte[] in, int bits2) {
        BitSetLite onBits = new BitSetLite(in);
        return new Tuple2<Object, Object>(BoxesRunTime.boxToInteger(this.j(onBits, bits2)), BoxesRunTime.boxToByte(this.rhoW(onBits, bits2)));
    }

    public byte[] toBytes(HLL h) {
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    if (!(h instanceof SparseHLL)) break block2;
                    SparseHLL sparseHLL = (SparseHLL)h;
                    int jLen = (sparseHLL.bits() + 7) / 8;
                    Predef$.MODULE$.assert(jLen >= 1);
                    Predef$.MODULE$.assert(jLen <= 3);
                    byte[] buf = new byte[2 + (jLen + 1) * sparseHLL.maxRhow().size()];
                    ByteBuffer byteBuf = ByteBuffer.wrap(buf).put((byte)3).put((byte)sparseHLL.bits());
                    sparseHLL.maxRhow().foldLeft((Max<Object>)((Object)byteBuf), (Function2<Max<Object>, Object, Max<Object>>)((Object)new Serializable(jLen){
                        public static final long serialVersionUID = 0L;
                        private final int jLen$1;

                        public final ByteBuffer apply(ByteBuffer bb, Tuple2<Object, Max<Object>> jrhow) {
                            if (jrhow != null) {
                                Tuple2<Integer, Max<Object>> tuple2 = new Tuple2<Integer, Max<Object>>(BoxesRunTime.boxToInteger(jrhow._1$mcI$sp()), jrhow._2());
                                int j = tuple2._1$mcI$sp();
                                Max<Object> rhow = tuple2._2();
                                bb.put((byte)(j & 0xFF));
                                Object object = this.jLen$1 >= 2 ? bb.put((byte)(j >> 8 & 0xFF)) : BoxedUnit.UNIT;
                                Object object2 = this.jLen$1 >= 3 ? bb.put((byte)(j >> 16 & 0xFF)) : BoxedUnit.UNIT;
                                return bb.put(BoxesRunTime.unboxToByte(rhow.get()));
                            }
                            throw new MatchError(jrhow);
                        }
                        {
                            this.jLen$1 = jLen$1;
                        }
                    }));
                    byArray = buf;
                    break block3;
                }
                if (!(h instanceof DenseHLL)) break block4;
                DenseHLL denseHLL = (DenseHLL)h;
                ByteBuffer bb = ByteBuffer.allocate(denseHLL.v().size() + 2);
                bb.put((byte)2);
                bb.put((byte)denseHLL.bits());
                bb.put(denseHLL.v().array());
                byArray = bb.array();
            }
            return byArray;
        }
        throw new MatchError(h);
    }

    public HLL fromBytes(byte[] bytes2) {
        return this.fromByteBuffer(ByteBuffer.wrap(bytes2));
    }

    public HLL fromByteBuffer(ByteBuffer bb) {
        HLL hLL;
        byte by2 = bb.get();
        switch (by2) {
            default: {
                throw new Exception(new StringBuilder().append((Object)"Unrecognized HLL type: ").append(BoxesRunTime.boxToInteger(by2)).toString());
            }
            case 3: {
                hLL = this.sparseFromByteBuffer(bb);
                break;
            }
            case 2: {
                byte bits2 = bb.get();
                byte[] buf = new byte[bb.remaining()];
                bb.get(buf);
                hLL = new DenseHLL(bits2, new Bytes(buf));
            }
        }
        return hLL;
    }

    private SparseHLL sparseFromByteBuffer(ByteBuffer bb) {
        byte bits2 = bb.get();
        int jLen = (bits2 + 7) / 8;
        boolean bl = bb.remaining() % (jLen + 1) == 0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Invalid byte array").toString());
        }
        Predef$ predef$2 = Predef$.MODULE$;
        int n = bb.remaining() / (jLen + 1);
        Map<Object, Max<Object>> maxRhow = ((TraversableOnce)Range$.MODULE$.inclusive(1, n).map(new Serializable(bb, jLen){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer bb$1;
            private final int jLen$2;

            public final Tuple2<Object, Max<Object>> apply(int x$3) {
                int n;
                int n2 = this.jLen$2;
                switch (n2) {
                    default: {
                        throw new MatchError(BoxesRunTime.boxToInteger(n2));
                    }
                    case 3: {
                        n = (this.bb$1.get() & 0xFF) + ((this.bb$1.get() & 0xFF) << 8) + ((this.bb$1.get() & 0xFF) << 16);
                        break;
                    }
                    case 2: {
                        n = (this.bb$1.get() & 0xFF) + ((this.bb$1.get() & 0xFF) << 8);
                        break;
                    }
                    case 1: {
                        n = this.bb$1.get() & 0xFF;
                    }
                }
                int j = n;
                byte rhow = this.bb$1.get();
                Integer n3 = BoxesRunTime.boxToInteger(j);
                Predef$ predef$ = Predef$.MODULE$;
                Max<Byte> max2 = new Max<Byte>(BoxesRunTime.boxToByte(rhow));
                Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
                return new Tuple2<Object, Max<Object>>(n3, max2);
            }
            {
                this.bb$1 = bb$1;
                this.jLen$2 = jLen$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return new SparseHLL(bits2, maxRhow);
    }

    public double alpha(int bits2) {
        double d;
        switch (bits2) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)(1 << bits2));
                break;
            }
            case 6: {
                d = 0.709;
                break;
            }
            case 5: {
                d = 0.697;
                break;
            }
            case 4: {
                d = 0.673;
            }
        }
        return d;
    }

    public double error(int bits2) {
        return 1.04 / package$.MODULE$.sqrt(Math.pow(2.0, bits2));
    }

    public int bitsForError(double err2) {
        boolean bl = err2 >= 3.0E-5 && err2 < 1.0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error must be in (0.00003, 1.0): ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(err2)}))).toString());
        }
        return (int)package$.MODULE$.ceil(2.0 * package$.MODULE$.log(1.04 / err2) / package$.MODULE$.log(2.0));
    }

    private final int loop$1(int pos, int accum, BitSetLite bsl$1, int bits$1) {
        while (pos < bits$1) {
            if (bsl$1.contains(pos)) {
                accum += 1 << pos;
                ++pos;
                continue;
            }
            ++pos;
        }
        return accum;
    }

    private final int loop$2(int pos, int zeros, BitSetLite bsl$2) {
        while (!bsl$2.contains(pos)) {
            ++zeros;
            ++pos;
        }
        return zeros;
    }

    private HyperLogLog$() {
        MODULE$ = this;
        this.hashSize = 128;
        Predef$ predef$ = Predef$.MODULE$;
        this.negativePowersOfTwo = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(0, this.hashSize()).map(new anonfun.1(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }
}

