/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.Approximate;
import com.twitter.algebird.BitSetLite;
import com.twitter.algebird.DenseHLL;
import com.twitter.algebird.HyperLogLog$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Predef$;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0002\"%\u00111\u0001\u0013'M\u0015\t\u0019A!\u0001\u0005bY\u001e,'-\u001b:e\u0015\t)a!A\u0004uo&$H/\u001a:\u000b\u0003\u001d\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0003S>T\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\ta1+\u001a:jC2L'0\u00192mK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u00011\taH\u0001\u0005E&$8/F\u0001!!\tY\u0011%\u0003\u0002#\u0019\t\u0019\u0011J\u001c;\t\u000b\u0011\u0002a\u0011A\u0010\u0002\tML'0\u001a\u0005\u0006M\u00011\taH\u0001\bu\u0016\u0014xn\u00118u\u0011\u0015A\u0003A\"\u0001*\u0003\u0005QX#\u0001\u0016\u0011\u0005-Y\u0013B\u0001\u0017\r\u0005\u0019!u.\u001e2mK\")a\u0006\u0001D\u0001_\u0005)A\u0005\u001d7vgR\u00111\u0004\r\u0005\u0006c5\u0002\raG\u0001\u0006_RDWM\u001d\u0005\u0006g\u00011\t\u0001N\u0001\u000bi>$UM\\:f\u00112cU#A\u001b\u0011\u0005q1\u0014BA\u001c\u0003\u0005!!UM\\:f\u00112c\u0005\"B\u001d\u0001\t\u0003Q\u0014aD1qaJ|\u00070[7bi\u0016\u001c\u0016N_3\u0016\u0003m\u00022\u0001\b\u001f?\u0013\ti$AA\u0006BaB\u0014x\u000e_5nCR,\u0007CA\u0006@\u0013\t\u0001EB\u0001\u0003M_:<\u0007\"\u0002\"\u0001\t\u0003I\u0013!D3ti&l\u0017\r^3e'&TX\r\u0003\u0005E\u0001!\u0015\r\u0011\"\u0003*\u0003=Ig.\u001b;jC2,5\u000f^5nCR,\u0007\u0002\u0003$\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0016\u0002!%t\u0017\u000e^5bY\u0016\u001bH/[7bi\u0016\u0004\u0003\"\u0002%\u0001\t\u0013I\u0015\u0001C1t\u0003B\u0004(o\u001c=\u0015\u0005mR\u0005\"B&H\u0001\u0004Q\u0013!\u0001<\t\u000b5\u0003A\u0011\u0002(\u0002\u001bMl\u0017\r\u001c7FgRLW.\u0019;f)\tQs\nC\u0003Q\u0019\u0002\u0007!&A\u0001f\u0011\u0015\u0011\u0006A\"\u0001T\u0003))\b\u000fZ1uK&sGo\u001c\u000b\u0003)^\u0003\"aC+\n\u0005Yc!\u0001B+oSRDQ\u0001W)A\u0002e\u000baAY;gM\u0016\u0014\bcA\u0006[9&\u00111\f\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017uK!A\u0018\u0007\u0003\t\tKH/\u001a\u0005\u0006A\u0002!\t\"Y\u0001\u0010O\u0016$Xj\u001c3jM&,GM\u00155p/R9AL\u00193gQ*d\u0007\"B2`\u0001\u0004\u0001\u0013\u0001C2veJ,g\u000e\u001e&\t\u000b\u0015|\u0006\u0019\u0001/\u0002\u0017\r,(O]3oiJCwn\u0016\u0005\u0006O~\u0003\r\u0001I\u0001\fe\u0016$WoY3e\u0005&$8\u000fC\u0003j?\u0002\u0007\u0001%A\u0006sK\u0012,8-\u001a3TSj,\u0007\"B6`\u0001\u0004\u0001\u0013a\u00022ji6\u000b7o\u001b\u0005\u0006[~\u0003\r!W\u0001\u0004EV4\u0007\"B8\u0001\t\u0003\u0001\u0018\u0001\u00033po:\u001c\u0018N_3\u0015\u0005m\t\b\"B4o\u0001\u0004\u0001\u0003\"B8\u0001\r#\u0019H#B\u000eukZ<\b\"B4s\u0001\u0004\u0001\u0003\"B5s\u0001\u0004\u0001\u0003\"B6s\u0001\u0004\u0001\u0003\"B7s\u0001\u0004I\u0016f\u0001\u00017s&\u0011!P\u0001\u0002\n'B\f'o]3I\u00192\u0003")
public abstract class HLL
implements Serializable {
    private double initialEstimate;
    private volatile boolean bitmap$0;

    private double initialEstimate$lzycompute() {
        HLL hLL = this;
        synchronized (hLL) {
            if (!this.bitmap$0) {
                double sizeDouble = this.size();
                double smallE = (double)5 * sizeDouble / 2.0;
                double factor = HyperLogLog$.MODULE$.alpha(this.bits()) * sizeDouble * sizeDouble;
                double e = factor * this.z();
                this.initialEstimate = e <= smallE ? this.smallEstimate(e) : e;
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.initialEstimate;
        }
    }

    public abstract int bits();

    public abstract int size();

    public abstract int zeroCnt();

    public abstract double z();

    public abstract HLL $plus(HLL var1);

    public abstract DenseHLL toDenseHLL();

    public Approximate<Object> approximateSize() {
        return this.asApprox(this.initialEstimate());
    }

    public double estimatedSize() {
        return this.initialEstimate();
    }

    private double initialEstimate() {
        return this.bitmap$0 ? this.initialEstimate : this.initialEstimate$lzycompute();
    }

    private Approximate<Object> asApprox(double v) {
        double stdev = HyperLogLog$.MODULE$.error(this.bits());
        long lowerBound = (long)package$.MODULE$.floor(package$.MODULE$.max(v * (1.0 - (double)3 * stdev), 0.0));
        long upperBound = (long)package$.MODULE$.ceil(v * (1.0 + (double)3 * stdev));
        return new Approximate<Object>(BoxesRunTime.boxToLong(lowerBound), BoxesRunTime.boxToLong((long)v), BoxesRunTime.boxToLong(upperBound), 0.9972, Numeric$LongIsIntegral$.MODULE$);
    }

    private double smallEstimate(double e) {
        return this.zeroCnt() == 0 ? e : (double)this.size() * package$.MODULE$.log((double)this.size() / (double)this.zeroCnt());
    }

    public abstract void updateInto(byte[] var1);

    public byte getModifiedRhoW(int currentJ, byte currentRhoW, int reducedBits, int reducedSize, int bitMask, byte[] buf) {
        byte by2;
        if (currentRhoW == 0) {
            by2 = currentRhoW;
        } else if (currentJ < reducedSize) {
            by2 = (byte)(currentRhoW + (this.bits() - reducedBits));
        } else {
            ByteBuffer.wrap(buf).putInt(Integer.reverse(currentJ | bitMask));
            by2 = HyperLogLog$.MODULE$.rhoW(new BitSetLite(buf), reducedBits);
        }
        return by2;
    }

    public HLL downsize(int reducedBits) {
        HLL hLL;
        boolean bl = reducedBits > 3 && reducedBits <= this.bits();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use at least 4, and at most ", " bits"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.bits())}))).toString());
        }
        if (reducedBits == this.bits()) {
            hLL = this;
        } else {
            int reducedSize = 1 << reducedBits;
            int bitMask = -1 << this.bits();
            byte[] buf = new byte[4];
            hLL = this.downsize(reducedBits, reducedSize, bitMask, buf);
        }
        return hLL;
    }

    public abstract HLL downsize(int var1, int var2, int var3, byte[] var4);
}

