/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.CMSHash;
import com.twitter.algebird.CMSHasher;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class CMSFunctions$ {
    public static final CMSFunctions$ MODULE$;

    static {
        new CMSFunctions$();
    }

    public double eps(int width) {
        return package$.MODULE$.exp(1.0) / (double)width;
    }

    public double delta(int depth) throws IllegalArgumentException {
        double i = 1.0 / package$.MODULE$.exp(depth);
        boolean bl = i != 0.0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"depth must be smaller as it causes precision errors when computing delta (", " led to an invalid delta of 0.0)"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(depth)}))).toString());
        }
        return i;
    }

    public int depth(double delta) throws IllegalArgumentException {
        boolean bl = 0.0 < delta && delta < 1.0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"delta must lie in (0, 1)").toString());
        }
        return (int)package$.MODULE$.ceil(package$.MODULE$.log(1.0 / delta));
    }

    public int width(double eps) {
        return (int)package$.MODULE$.ceil(this.truncatePrecisionError(package$.MODULE$.exp(1.0) / eps, this.truncatePrecisionError$default$2()));
    }

    public int maxExactCount(Option<Object> maxExactCountOpt, int depth, int width) {
        return BoxesRunTime.unboxToInt(!maxExactCountOpt.isEmpty() ? maxExactCountOpt.get() : BoxesRunTime.boxToInteger(package$.MODULE$.max(width * depth / 100, 50)));
    }

    private double truncatePrecisionError(double i, int decimalPlaces) {
        return scala.package$.MODULE$.BigDecimal().apply(i).setScale(decimalPlaces, BigDecimal$RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    private int truncatePrecisionError$default$2() {
        return 6;
    }

    public <K> Seq<CMSHash<K>> generateHashes(double eps, double delta, int seed, CMSHasher<K> evidence$2) {
        Random r = new Random(seed);
        int numHashes = this.depth(delta);
        int numCounters = this.width(eps);
        Predef$ predef$ = Predef$.MODULE$;
        return RichInt$.MODULE$.to$extension0(0, numHashes - 1).map(new Serializable(evidence$2, r, numCounters){
            public static final long serialVersionUID = 0L;
            private final CMSHasher evidence$2$1;
            private final Random r$1;
            private final int numCounters$1;

            public final CMSHash<K> apply(int x$1) {
                return new CMSHash<K>(this.r$1.nextInt(), 0, this.numCounters$1, this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.r$1 = r$1;
                this.numCounters$1 = numCounters$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private CMSFunctions$() {
        MODULE$ = this;
    }
}

