/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import com.hadoop.compression.lzo.LzoIndex;
import com.hadoop.compression.lzo.LzoInputFormatCommon;
import com.hadoop.compression.lzo.util.CompatibilityUtil;
import com.hadoop.mapreduce.LzoLineRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class LzoTextInputFormat
extends TextInputFormat {
    private final Map<Path, LzoIndex> indexes = new HashMap<Path, LzoIndex>();

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List files2 = super.listStatus(job);
        Configuration conf = CompatibilityUtil.getConfiguration(job);
        boolean ignoreNonLzo = LzoInputFormatCommon.getIgnoreNonLzoProperty(conf);
        Iterator iterator2 = files2.iterator();
        while (iterator2.hasNext()) {
            FileStatus fileStatus = (FileStatus)iterator2.next();
            Path file = fileStatus.getPath();
            FileSystem fs = file.getFileSystem(conf);
            if (!LzoInputFormatCommon.isLzoFile(file.toString())) {
                if (!ignoreNonLzo && !LzoInputFormatCommon.isLzoIndexFile(file.toString())) continue;
                iterator2.remove();
                continue;
            }
            LzoIndex index2 = LzoIndex.readIndex(fs, file);
            this.indexes.put(file, index2);
        }
        return files2;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        if (LzoInputFormatCommon.isLzoFile(filename.toString())) {
            LzoIndex index2 = this.indexes.get(filename);
            return !index2.isEmpty();
        }
        return super.isSplitable(context, filename);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = super.getSplits(job);
        Configuration conf = CompatibilityUtil.getConfiguration(job);
        ArrayList<InputSplit> result2 = new ArrayList<InputSplit>();
        for (InputSplit genericSplit : splits) {
            FileSplit fileSplit = (FileSplit)genericSplit;
            Path file = fileSplit.getPath();
            FileSystem fs = file.getFileSystem(conf);
            if (!LzoInputFormatCommon.isLzoFile(file.toString())) {
                result2.add((InputSplit)fileSplit);
                continue;
            }
            LzoIndex index2 = this.indexes.get(file);
            if (index2 == null) {
                throw new IOException("Index not found for " + file);
            }
            if (index2.isEmpty()) {
                result2.add((InputSplit)fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long lzoStart = index2.alignSliceStartToIndex(start, end);
            long lzoEnd = index2.alignSliceEndToIndex(end, fs.getFileStatus(file).getLen());
            if (lzoStart == -1L || lzoEnd == -1L) continue;
            result2.add((InputSplit)new FileSplit(file, lzoStart, lzoEnd - lzoStart, fileSplit.getLocations()));
        }
        return result2;
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split2, TaskAttemptContext taskAttempt) {
        FileSplit fileSplit = (FileSplit)split2;
        if (LzoInputFormatCommon.isLzoFile(fileSplit.getPath().toString())) {
            return new LzoLineRecordReader();
        }
        return super.createRecordReader(split2, taskAttempt);
    }
}

