/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import com.hadoop.compression.lzo.LzopDecompressor;
import com.hadoop.compression.lzo.util.CompatibilityUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class LzoSplitRecordReader
extends RecordReader<Path, LongWritable> {
    private static final Log LOG = LogFactory.getLog(LzoSplitRecordReader.class);
    private final int LOG_EVERY_N_BLOCKS = 1000;
    private final LongWritable curValue = new LongWritable(-1L);
    private FSDataInputStream rawInputStream;
    private TaskAttemptContext context;
    private int numBlocksRead = 0;
    private int numDecompressedChecksums = -1;
    private int numCompressedChecksums = -1;
    private long totalFileSize = 0L;
    private Path lzoFile;
    private Counter readSuccessCounter = null;

    public void initialize(InputSplit genericSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        this.context = taskAttemptContext;
        FileSplit fileSplit = (FileSplit)genericSplit;
        this.lzoFile = fileSplit.getPath();
        this.totalFileSize = fileSplit.getLength();
        if (taskAttemptContext instanceof TaskInputOutputContext) {
            this.readSuccessCounter = CompatibilityUtil.getCounter((TaskInputOutputContext)taskAttemptContext, Counters.READ_SUCCESS);
        }
        Configuration conf = CompatibilityUtil.getConfiguration((JobContext)this.context);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(this.lzoFile);
        ((Configurable)codec).setConf(conf);
        LzopDecompressor lzopDecompressor = (LzopDecompressor)codec.createDecompressor();
        FileSystem fs = this.lzoFile.getFileSystem(conf);
        this.rawInputStream = fs.open(this.lzoFile);
        codec.createInputStream((InputStream)this.rawInputStream, (Decompressor)lzopDecompressor);
        this.numCompressedChecksums = lzopDecompressor.getCompressedChecksumsCount();
        this.numDecompressedChecksums = lzopDecompressor.getDecompressedChecksumsCount();
    }

    public boolean nextKeyValue() throws IOException {
        try {
            int uncompressedBlockSize = this.rawInputStream.readInt();
            if (uncompressedBlockSize == 0) {
                if (this.readSuccessCounter != null) {
                    CompatibilityUtil.incrementCounter(this.readSuccessCounter, 1L);
                }
                return false;
            }
            if (uncompressedBlockSize < 0) {
                throw new EOFException("Could not read uncompressed block size at position " + this.rawInputStream.getPos() + " in file " + this.lzoFile);
            }
            int compressedBlockSize = this.rawInputStream.readInt();
            if (compressedBlockSize <= 0) {
                throw new EOFException("Could not read compressed block size at position " + this.rawInputStream.getPos() + " in file " + this.lzoFile);
            }
            boolean isUncompressedBlock = uncompressedBlockSize == compressedBlockSize;
            int numChecksumsToSkip = isUncompressedBlock ? this.numDecompressedChecksums : this.numDecompressedChecksums + this.numCompressedChecksums;
            long pos = this.rawInputStream.getPos();
            this.curValue.set(pos - 8L);
            long nextBlockOffset = pos + (long)compressedBlockSize + (long)(4 * numChecksumsToSkip);
            if (nextBlockOffset >= this.totalFileSize) {
                throw new EOFException("truncated");
            }
            this.rawInputStream.seek(nextBlockOffset);
            ++this.numBlocksRead;
            if (this.numBlocksRead % 1000 == 0) {
                LOG.info("Reading block " + this.numBlocksRead + " at pos " + pos + " of " + this.totalFileSize + ". Read is " + 100.0 * (double)this.getProgress() + "% done. ");
            }
            return true;
        }
        catch (EOFException e) {
            LOG.info("Received an EOFException. Mostly a truncated file, which is ok : ", e);
            if (this.readSuccessCounter != null) {
                CompatibilityUtil.incrementCounter(this.readSuccessCounter, 1L);
            }
            return false;
        }
        catch (IOException e) {
            LOG.warn("Exception while trying to read from " + this.lzoFile, e);
            return false;
        }
    }

    public Path getCurrentKey() {
        return this.lzoFile;
    }

    public LongWritable getCurrentValue() {
        return this.curValue;
    }

    public float getProgress() throws IOException {
        if (this.totalFileSize == 0L) {
            return 0.0f;
        }
        return (float)this.rawInputStream.getPos() / (float)this.totalFileSize;
    }

    public void close() throws IOException {
        LOG.info("Closing input stream after reading " + this.numBlocksRead + " blocks from " + this.lzoFile);
        this.rawInputStream.close();
    }

    public static enum Counters {
        READ_SUCCESS;

    }
}

