/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.LzoCompressor;
import com.hadoop.compression.lzo.LzopCodec;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Adler32;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;

public class LzopOutputStream
extends CompressorStream {
    final int MAX_INPUT_SIZE;
    protected DataOutputStream indexOut;
    private CountingOutputStream cout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeLzopHeader(OutputStream out, LzoCompressor.CompressionStrategy strategy) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            dob.writeShort(4112);
            dob.writeShort(LzoCompressor.LZO_LIBRARY_VERSION);
            dob.writeShort(2368);
            switch (strategy) {
                case LZO1X_1: {
                    dob.writeByte(1);
                    dob.writeByte(5);
                    break;
                }
                case LZO1X_15: {
                    dob.writeByte(2);
                    dob.writeByte(1);
                    break;
                }
                case LZO1X_999: {
                    dob.writeByte(3);
                    dob.writeByte(9);
                    break;
                }
                default: {
                    throw new IOException("Incompatible lzop strategy: " + (Object)((Object)strategy));
                }
            }
            dob.writeInt(0);
            dob.writeInt(33188);
            dob.writeInt((int)(System.currentTimeMillis() / 1000L));
            dob.writeInt(0);
            dob.writeByte(0);
            Adler32 headerChecksum = new Adler32();
            headerChecksum.update(dob.getData(), 0, dob.getLength());
            int hc = (int)headerChecksum.getValue();
            dob.writeInt(hc);
            out.write(LzopCodec.LZO_MAGIC);
            out.write(dob.getData(), 0, dob.getLength());
        }
        finally {
            dob.close();
        }
    }

    public LzopOutputStream(OutputStream out, Compressor compressor, int bufferSize, LzoCompressor.CompressionStrategy strategy) throws IOException {
        this(out, null, compressor, bufferSize, strategy);
    }

    public LzopOutputStream(OutputStream out, DataOutputStream indexOut, Compressor compressor, int bufferSize, LzoCompressor.CompressionStrategy strategy) throws IOException {
        super((OutputStream)new CountingOutputStream(out), compressor, bufferSize);
        this.cout = (CountingOutputStream)this.out;
        this.indexOut = indexOut;
        int overhead = strategy.name().contains("LZO1") ? (bufferSize >> 4) + 64 + 3 : (bufferSize >> 3) + 128 + 3;
        this.MAX_INPUT_SIZE = bufferSize - overhead;
        LzopOutputStream.writeLzopHeader(this.out, strategy);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.out.write(new byte[]{0, 0, 0, 0});
            this.out.close();
            if (this.indexOut != null) {
                this.indexOut.close();
            }
            this.closed = true;
            CodecPool.returnCompressor((Compressor)this.compressor);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.compressor.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        long limlen = this.compressor.getBytesRead();
        if ((long)len + limlen > (long)this.MAX_INPUT_SIZE && limlen > 0L) {
            this.finish();
            this.compressor.reset();
        }
        if (len > this.MAX_INPUT_SIZE) {
            int bufLen;
            do {
                bufLen = Math.min(len, this.MAX_INPUT_SIZE);
                this.compressor.setInput(b, off, bufLen);
                this.finish();
                this.compressor.reset();
                off += bufLen;
            } while ((len -= bufLen) > 0);
            return;
        }
        this.compressor.setInput(b, off, len);
        if (!this.compressor.needsInput()) {
            do {
                this.compress();
            } while (!this.compressor.needsInput());
        }
    }

    public void finish() throws IOException {
        if (!this.compressor.finished()) {
            this.compressor.finish();
            while (!this.compressor.finished()) {
                this.compress();
            }
        }
    }

    protected void compress() throws IOException {
        int len = this.compressor.compress(this.buffer, 0, this.buffer.length);
        if (len > 0) {
            if (this.indexOut != null) {
                this.indexOut.writeLong(this.cout.bytesWritten);
            }
            this.rawWriteInt((int)this.compressor.getBytesRead());
            if (this.compressor.getBytesRead() <= this.compressor.getBytesWritten()) {
                byte[] uncompressed = ((LzoCompressor)this.compressor).uncompressedBytes();
                this.rawWriteInt(uncompressed.length);
                this.out.write(uncompressed, 0, uncompressed.length);
            } else {
                this.rawWriteInt(len);
                this.out.write(this.buffer, 0, len);
            }
        }
    }

    private void rawWriteInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        long bytesWritten = 0L;

        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.bytesWritten += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.bytesWritten;
        }
    }
}

