/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.LzoCodec;
import com.hadoop.compression.lzo.LzoCompressor;
import com.hadoop.compression.lzo.LzopDecompressor;
import com.hadoop.compression.lzo.LzopInputStream;
import com.hadoop.compression.lzo.LzopOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class LzopCodec
extends LzoCodec {
    public static final byte[] LZO_MAGIC = new byte[]{-119, 76, 90, 79, 0, 13, 10, 26, 10};
    public static final int LZOP_VERSION = 4112;
    public static final int LZOP_COMPAT_VERSION = 2368;
    public static final String DEFAULT_LZO_EXTENSION = ".lzo";
    private static boolean codecPoolSupportsConf = false;

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.getCompressor());
    }

    public CompressionOutputStream createIndexedOutputStream(OutputStream out, DataOutputStream indexOut) throws IOException {
        return this.createIndexedOutputStream(out, indexOut, this.getCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return this.createIndexedOutputStream(out, null, compressor);
    }

    public CompressionOutputStream createIndexedOutputStream(OutputStream out, DataOutputStream indexOut, Compressor compressor) throws IOException {
        if (!LzopCodec.isNativeLzoLoaded(this.getConf())) {
            throw new RuntimeException("native-lzo library not available");
        }
        LzoCompressor.CompressionStrategy strategy = LzoCompressor.CompressionStrategy.valueOf(this.getConf().get("io.compression.codec.lzo.compressor", LzoCompressor.CompressionStrategy.LZO1X_1.name()));
        int bufferSize = this.getConf().getInt("io.compression.codec.lzo.buffersize", 262144);
        return new LzopOutputStream(out, indexOut, compressor, bufferSize, strategy);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!LzopCodec.isNativeLzoLoaded(this.getConf())) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new LzopInputStream(in, decompressor, this.getConf().getInt("io.compression.codec.lzo.buffersize", 262144));
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, CodecPool.getDecompressor((CompressionCodec)this));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!LzopCodec.isNativeLzoLoaded(this.getConf())) {
            throw new RuntimeException("native-lzo library not available");
        }
        return LzopDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!LzopCodec.isNativeLzoLoaded(this.getConf())) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new LzopDecompressor(this.getConf().getInt("io.compression.codec.lzo.buffersize", 262144));
    }

    private Compressor getCompressor() {
        if (codecPoolSupportsConf) {
            return CodecPool.getCompressor((CompressionCodec)this, (Configuration)this.getConf());
        }
        return CodecPool.getCompressor((CompressionCodec)this);
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_LZO_EXTENSION;
    }

    static {
        try {
            codecPoolSupportsConf = null != CodecPool.class.getMethod("getCompressor", CompressionCodec.class, Configuration.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

