/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.GPLNativeCodeLoader;
import com.hadoop.compression.lzo.LzoCodec;
import com.hadoop.compression.lzo.LzoDecompressor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;

class LzoCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog(LzoCompressor.class.getName());
    private static Class clazz = LzoDecompressor.class;
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private ByteBuffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufLen = 0;
    private ByteBuffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private CompressionStrategy strategy;
    private long lzoCompressor = 0L;
    private int workingMemoryBufLen = 0;
    private long lzoCompressLevelFunc = 0L;
    private ByteBuffer workingMemoryBuf;
    private int lzoCompressionLevel;
    private static Configuration defaultConfiguration = new Configuration();
    private static boolean nativeLzoLoaded;
    public static final int LZO_LIBRARY_VERSION;

    public static boolean isNativeLzoLoaded() {
        return nativeLzoLoaded;
    }

    public LzoCompressor(Configuration conf) {
        this.reinit(conf);
    }

    public void reinit(Configuration conf) {
        if (conf == null) {
            conf = defaultConfiguration;
        }
        CompressionStrategy strategy = LzoCodec.getCompressionStrategy(conf);
        int compressionLevel = LzoCodec.getCompressionLevel(conf);
        int bufferSize = LzoCodec.getBufferSize(conf);
        this.init(strategy, compressionLevel, bufferSize);
    }

    public LzoCompressor(CompressionStrategy strategy, int directBufferSize) {
        this.init(strategy, -999, directBufferSize);
    }

    private ByteBuffer realloc(ByteBuffer buf, int newSize) {
        if (buf != null) {
            if (buf.capacity() == newSize) {
                buf.clear();
                return buf;
            }
            try {
                Method cleanerMethod = buf.getClass().getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                Object cleaner = cleanerMethod.invoke((Object)buf, new Object[0]);
                Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                cleanMethod.setAccessible(true);
                cleanMethod.invoke(cleaner, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Couldn't realloc bytebuffer", e);
            }
        }
        return ByteBuffer.allocateDirect(newSize);
    }

    private void init(CompressionStrategy strategy, int compressionLevel, int directBufferSize) {
        this.strategy = strategy;
        this.lzoCompressionLevel = compressionLevel;
        this.directBufferSize = directBufferSize;
        this.uncompressedDirectBuf = this.realloc(this.uncompressedDirectBuf, directBufferSize);
        this.compressedDirectBuf = this.realloc(this.compressedDirectBuf, directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
        this.reset();
        this.init(this.strategy.getCompressor());
        this.workingMemoryBuf = this.realloc(this.workingMemoryBuf, this.workingMemoryBufLen);
    }

    public LzoCompressor() {
        this(CompressionStrategy.LZO1X_1, 65536);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.finished = false;
        if (len > this.uncompressedDirectBuf.remaining()) {
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        } else {
            this.uncompressedDirectBuf.put(b, off, len);
            this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
        }
        this.bytesRead += (long)len;
    }

    synchronized void setInputFromSavedData() {
        if (0 >= this.userBufLen) {
            return;
        }
        this.finished = false;
        this.uncompressedDirectBufLen = Math.min(this.userBufLen, this.directBufferSize);
        this.uncompressedDirectBuf.put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        return this.compressedDirectBuf.remaining() <= 0 && this.uncompressedDirectBuf.remaining() != 0 && this.userBufLen <= 0;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finish && this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            this.compressedDirectBuf.get(b, off, n);
            this.bytesWritten += (long)n;
            return n;
        }
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        if (0 == this.uncompressedDirectBuf.position()) {
            this.setInputFromSavedData();
            if (0 == this.uncompressedDirectBuf.position()) {
                this.finished = true;
                return 0;
            }
        }
        n = this.compressBytesDirect(this.strategy.getCompressor());
        this.compressedDirectBuf.limit(n);
        this.uncompressedDirectBuf.clear();
        if (0 == this.userBufLen) {
            this.finished = true;
        }
        n = Math.min(n, len);
        this.bytesWritten += (long)n;
        this.compressedDirectBuf.get(b, off, n);
        return n;
    }

    public synchronized void reset() {
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.clear();
        this.uncompressedDirectBufLen = 0;
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
    }

    public synchronized long getBytesRead() {
        return this.bytesRead;
    }

    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }

    public byte[] uncompressedBytes() {
        byte[] b = new byte[(int)this.bytesRead];
        this.uncompressedDirectBuf.get(b);
        return b;
    }

    long getDirectBufferSize() {
        return this.directBufferSize;
    }

    public synchronized void end() {
    }

    CompressionStrategy getStrategy() {
        return this.strategy;
    }

    private static native void initIDs();

    private static native int getLzoLibraryVersion();

    private native void init(int var1);

    private native int compressBytesDirect(int var1);

    static {
        if (GPLNativeCodeLoader.isNativeCodeLoaded()) {
            try {
                LzoCompressor.initIDs();
                nativeLzoLoaded = true;
            }
            catch (Throwable t) {
                LOG.warn(t.toString());
                nativeLzoLoaded = false;
            }
            LZO_LIBRARY_VERSION = nativeLzoLoaded ? 0xFFFF & LzoCompressor.getLzoLibraryVersion() : -1;
        } else {
            LOG.error("Cannot load " + LzoCompressor.class.getName() + " without native-hadoop library!");
            nativeLzoLoaded = false;
            LZO_LIBRARY_VERSION = -1;
        }
    }

    public static enum CompressionStrategy {
        LZO1(0),
        LZO1_99(1),
        LZO1A(2),
        LZO1A_99(3),
        LZO1B(4),
        LZO1B_BEST_COMPRESSION(5),
        LZO1B_BEST_SPEED(6),
        LZO1B_1(7),
        LZO1B_2(8),
        LZO1B_3(9),
        LZO1B_4(10),
        LZO1B_5(11),
        LZO1B_6(12),
        LZO1B_7(13),
        LZO1B_8(14),
        LZO1B_9(15),
        LZO1B_99(16),
        LZO1B_999(17),
        LZO1C(18),
        LZO1C_BEST_COMPRESSION(19),
        LZO1C_BEST_SPEED(20),
        LZO1C_1(21),
        LZO1C_2(22),
        LZO1C_3(23),
        LZO1C_4(24),
        LZO1C_5(25),
        LZO1C_6(26),
        LZO1C_7(27),
        LZO1C_8(28),
        LZO1C_9(29),
        LZO1C_99(30),
        LZO1C_999(31),
        LZO1F_1(32),
        LZO1F_999(33),
        LZO1X_1(34),
        LZO1X_11(35),
        LZO1X_12(36),
        LZO1X_15(37),
        LZO1X_999(38),
        LZO1Y_1(39),
        LZO1Y_999(40),
        LZO1Z_999(41),
        LZO2A_999(42);

        private final int compressor;

        private CompressionStrategy(int compressor) {
            this.compressor = compressor;
        }

        int getCompressor() {
            return this.compressor;
        }
    }
}

