/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

public final class RunningLengthWord32 {
    public int[] array;
    public int position;
    public static final int runninglengthbits = 16;
    private static final int literalbits = 15;
    public static final int largestliteralcount = Short.MAX_VALUE;
    public static final int largestrunninglengthcount = 65535;
    private static final int runninglengthplusrunningbit = 131071;
    private static final int shiftedlargestrunninglengthcount = 131070;
    private static final int notrunninglengthplusrunningbit = -131072;
    private static final int notshiftedlargestrunninglengthcount = -131071;

    RunningLengthWord32(int[] a, int p) {
        this.array = a;
        this.position = p;
    }

    public int getNumberOfLiteralWords() {
        return this.array[this.position] >>> 17;
    }

    public boolean getRunningBit() {
        return (this.array[this.position] & 1) != 0;
    }

    public int getRunningLength() {
        return this.array[this.position] >>> 1 & 0xFFFF;
    }

    public void setNumberOfLiteralWords(int number2) {
        int n = this.position;
        this.array[n] = this.array[n] | 0xFFFE0000;
        int n2 = this.position;
        this.array[n2] = this.array[n2] & (number2 << 17 | 0x1FFFF);
    }

    public void setRunningBit(boolean b) {
        if (b) {
            int n = this.position;
            this.array[n] = this.array[n] | 1;
        } else {
            int n = this.position;
            this.array[n] = this.array[n] & 0xFFFFFFFE;
        }
    }

    public void setRunningLength(int number2) {
        int n = this.position;
        this.array[n] = this.array[n] | 0x1FFFE;
        int n2 = this.position;
        this.array[n2] = this.array[n2] & (number2 << 1 | 0xFFFE0001);
    }

    public int size() {
        return this.getRunningLength() + this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }
}

