/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;
import java.util.List;

public class benchmark {
    public static void main(String[] args2) {
        benchmark.test(100, 16, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; sparsity += 4) {
            int k;
            int r;
            long bogus = 0L;
            String line = "";
            line = line + sparsity;
            int[][] data2 = new int[N][];
            int Max2 = 1 << nbr + sparsity;
            System.out.println("# generating random data...");
            for (int k2 = 0; k2 < N; ++k2) {
                data2[k2] = cdg.generateClustered(1 << nbr, Max2);
            }
            System.out.println("# generating random data... ok.");
            long bef = System.currentTimeMillis();
            EWAHCompressedBitmap[] ewah = new EWAHCompressedBitmap[N];
            int size2 = 0;
            for (r = 0; r < repeat; ++r) {
                size2 = 0;
                for (k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data2[k].length; ++x) {
                        ewah[k].set(data2[k][x]);
                    }
                    size2 += ewah[k].sizeInBytes();
                }
            }
            long aft = System.currentTimeMillis();
            line = line + "\t" + size2;
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    int[] array2 = ewah[k].toArray();
                    bogus += (long)array2.length;
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    int[] array3 = new int[ewah[k].cardinality()];
                    int c = 0;
                    for (int x : ewah[k]) {
                        array3[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    List<Integer> L = ewah[k].getPositions();
                    int[] array4 = new int[L.size()];
                    int c = 0;
                    for (int x : L) {
                        array4[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    IntIterator iter2 = ewah[k].intIterator();
                    while (iter2.hasNext()) {
                        bogus += (long)iter2.next();
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap ewahor = ewah[0];
                    for (int j = 1; j < k; ++j) {
                        ewahor = ewahor.or(ewah[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahor = EWAHCompressedBitmap.or(ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    LogicalElement[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahor = (EWAHCompressedBitmap)FastAggregation.or((LogicalElement[])ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap ewahand = ewah[0];
                    for (int j = 1; j < k; ++j) {
                        ewahand = ewahand.and(ewah[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahand = EWAHCompressedBitmap.and(ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    LogicalElement[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahand = (EWAHCompressedBitmap)FastAggregation.and((LogicalElement[])ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            System.out.println("time for building, toArray(), Java iterator, intIterator, logical or (2-by-2), logical or (grouped), FastAggregation.or, and (2-by-2),  logical and (grouped),FastAggregation.and");
            System.out.println(line);
            System.out.println("# bogus =" + bogus);
        }
    }
}

