/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.benchmark.UniformDataGenerator;

class ClusteredDataGenerator {
    UniformDataGenerator unidg = new UniformDataGenerator();

    public int[] generateClustered(int N, int Max2) {
        int[] array2 = new int[N];
        this.fillClustered(array2, 0, N, 0, Max2);
        return array2;
    }

    void fillClustered(int[] array2, int offset, int length, int Min2, int Max2) {
        int range2 = Max2 - Min2;
        if (range2 == length || length <= 10) {
            this.fillUniform(array2, offset, length, Min2, Max2);
            return;
        }
        int cut = length / 2 + (range2 - length - 1 > 0 ? this.unidg.rand.nextInt(range2 - length - 1) : 0);
        double p = this.unidg.rand.nextDouble();
        if (p < 0.25) {
            this.fillUniform(array2, offset, length / 2, Min2, Min2 + cut);
            this.fillClustered(array2, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        } else if (p < 0.5) {
            this.fillClustered(array2, offset, length / 2, Min2, Min2 + cut);
            this.fillUniform(array2, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        } else {
            this.fillClustered(array2, offset, length / 2, Min2, Min2 + cut);
            this.fillClustered(array2, offset + length / 2, length - length / 2, Min2 + cut, Max2);
        }
    }

    void fillUniform(int[] array2, int offset, int length, int Min2, int Max2) {
        int[] v = this.unidg.generateUniform(length, Max2 - Min2);
        for (int k = 0; k < v.length; ++k) {
            array2[k + offset] = Min2 + v[k];
        }
    }

    public static void main(String[] args2) {
        int[] example = new ClusteredDataGenerator().generateClustered(20, 1000);
        for (int k = 0; k < example.length; ++k) {
            System.out.println(example[k]);
        }
    }
}

