/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;

public final class IteratingBufferedRunningLengthWord {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator iterator2) {
        this.iterator = iterator2;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord(EWAHCompressedBitmap bitmap) {
        this(EWAHIterator.getEWAHIterator(bitmap));
    }

    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0L;
            long toDiscard = (x -= this.brlw.RunningLength) > (long)this.brlw.NumberOfLiteralWords ? (long)this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.NumberOfLiteralWords = (int)((long)this.brlw.NumberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        }
    }

    public long discharge(BitmapStorage container2, long max2) {
        long index2;
        int pd;
        for (index2 = 0L; index2 < max2 && this.size() > 0L; index2 += (long)pd) {
            long pl = this.getRunningLength();
            if (index2 + pl > max2) {
                pl = max2 - index2;
            }
            container2.addStreamOfEmptyWords(this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index2 += pl) > max2) {
                pd = (int)(max2 - index2);
            }
            this.writeLiteralWords(pd, container2);
            this.discardFirstWords(pl + (long)pd);
        }
        return index2;
    }

    public long dischargeNegated(BitmapStorage container2, long max2) {
        long index2;
        int pd;
        for (index2 = 0L; index2 < max2 && this.size() > 0L; index2 += (long)pd) {
            long pl = this.getRunningLength();
            if (index2 + pl > max2) {
                pl = max2 - index2;
            }
            container2.addStreamOfEmptyWords(!this.getRunningBit(), pl);
            this.discardFirstWords(pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index2 += pl) > max2) {
                pd = (int)(max2 - index2);
            }
            this.writeNegatedLiteralWords(pd, container2);
            this.discardFirstWords(pd);
        }
        return index2;
    }

    public void dischargeAsEmpty(BitmapStorage container2) {
        while (this.size() > 0L) {
            container2.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage container2) {
        this.brlw.literalwordoffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord.discharge(this.brlw, this.iterator, container2);
    }

    public long getLiteralWordAt(int index2) {
        return this.buffer[this.literalWordStartPosition + index2];
    }

    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    public long getRunningLength() {
        return this.brlw.RunningLength;
    }

    public long size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage container2) {
        container2.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    public void writeNegatedLiteralWords(int numWords, BitmapStorage container2) {
        container2.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    private static void discharge(BufferedRunningLengthWord initialWord, EWAHIterator iterator2, BitmapStorage container2) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container2.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container2.addStreamOfLiteralWords(iterator2.buffer(), iterator2.literalWords() + runningLengthWord.literalwordoffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator2.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator2.next());
        }
    }
}

