/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private final OutputStream output;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    static int computePreferredBufferSize(int dataLength) {
        if (dataLength > 4096) {
            return 4096;
        }
        return dataLength;
    }

    private CodedOutputStream(byte[] buffer2, int offset, int length) {
        this.output = null;
        this.buffer = buffer2;
        this.position = offset;
        this.limit = offset + length;
    }

    private CodedOutputStream(OutputStream output, byte[] buffer2) {
        this.output = output;
        this.buffer = buffer2;
        this.position = 0;
        this.limit = buffer2.length;
    }

    public static CodedOutputStream newInstance(OutputStream output) {
        return CodedOutputStream.newInstance(output, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream output, int bufferSize) {
        return new CodedOutputStream(output, new byte[bufferSize]);
    }

    public static CodedOutputStream newInstance(byte[] flatArray) {
        return CodedOutputStream.newInstance(flatArray, 0, flatArray.length);
    }

    public static CodedOutputStream newInstance(byte[] flatArray, int offset, int length) {
        return new CodedOutputStream(flatArray, offset, length);
    }

    public void writeDouble(int fieldNumber, double value2) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeDoubleNoTag(value2);
    }

    public void writeFloat(int fieldNumber, float value2) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFloatNoTag(value2);
    }

    public void writeUInt64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value2);
    }

    public void writeInt64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt64NoTag(value2);
    }

    public void writeInt32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value2);
    }

    public void writeFixed64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value2);
    }

    public void writeFixed32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value2);
    }

    public void writeBool(int fieldNumber, boolean value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value2);
    }

    public void writeString(int fieldNumber, String value2) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value2);
    }

    public void writeGroup(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value2);
        this.writeTag(fieldNumber, 4);
    }

    @Deprecated
    public void writeUnknownGroup(int fieldNumber, MessageLite value2) throws IOException {
        this.writeGroup(fieldNumber, value2);
    }

    public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value2);
    }

    public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value2);
    }

    public void writeUInt32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value2);
    }

    public void writeEnum(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value2);
    }

    public void writeSFixed32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeSFixed32NoTag(value2);
    }

    public void writeSFixed64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeSFixed64NoTag(value2);
    }

    public void writeSInt32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt32NoTag(value2);
    }

    public void writeSInt64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt64NoTag(value2);
    }

    public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, fieldNumber);
        this.writeMessage(3, value2);
        this.writeTag(1, 4);
    }

    public void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, fieldNumber);
        this.writeBytes(3, value2);
        this.writeTag(1, 4);
    }

    public void writeDoubleNoTag(double value2) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(value2));
    }

    public void writeFloatNoTag(float value2) throws IOException {
        this.writeRawLittleEndian32(Float.floatToRawIntBits(value2));
    }

    public void writeUInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(value2);
    }

    public void writeInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(value2);
    }

    public void writeInt32NoTag(int value2) throws IOException {
        if (value2 >= 0) {
            this.writeRawVarint32(value2);
        } else {
            this.writeRawVarint64(value2);
        }
    }

    public void writeFixed64NoTag(long value2) throws IOException {
        this.writeRawLittleEndian64(value2);
    }

    public void writeFixed32NoTag(int value2) throws IOException {
        this.writeRawLittleEndian32(value2);
    }

    public void writeBoolNoTag(boolean value2) throws IOException {
        this.writeRawByte(value2 ? 1 : 0);
    }

    public void writeStringNoTag(String value2) throws IOException {
        byte[] bytes2 = value2.getBytes("UTF-8");
        this.writeRawVarint32(bytes2.length);
        this.writeRawBytes(bytes2);
    }

    public void writeGroupNoTag(MessageLite value2) throws IOException {
        value2.writeTo(this);
    }

    @Deprecated
    public void writeUnknownGroupNoTag(MessageLite value2) throws IOException {
        this.writeGroupNoTag(value2);
    }

    public void writeMessageNoTag(MessageLite value2) throws IOException {
        this.writeRawVarint32(value2.getSerializedSize());
        value2.writeTo(this);
    }

    public void writeBytesNoTag(ByteString value2) throws IOException {
        this.writeRawVarint32(value2.size());
        this.writeRawBytes(value2);
    }

    public void writeUInt32NoTag(int value2) throws IOException {
        this.writeRawVarint32(value2);
    }

    public void writeEnumNoTag(int value2) throws IOException {
        this.writeInt32NoTag(value2);
    }

    public void writeSFixed32NoTag(int value2) throws IOException {
        this.writeRawLittleEndian32(value2);
    }

    public void writeSFixed64NoTag(long value2) throws IOException {
        this.writeRawLittleEndian64(value2);
    }

    public void writeSInt32NoTag(int value2) throws IOException {
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(value2));
    }

    public void writeSInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(value2));
    }

    public static int computeDoubleSize(int fieldNumber, double value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag(value2);
    }

    public static int computeFloatSize(int fieldNumber, float value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag(value2);
    }

    public static int computeUInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    public static int computeInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt64SizeNoTag(value2);
    }

    public static int computeInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeFixed64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed64SizeNoTag(value2);
    }

    public static int computeFixed32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed32SizeNoTag(value2);
    }

    public static int computeBoolSize(int fieldNumber, boolean value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag(value2);
    }

    public static int computeStringSize(int fieldNumber, String value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag(value2);
    }

    public static int computeGroupSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) * 2 + CodedOutputStream.computeGroupSizeNoTag(value2);
    }

    @Deprecated
    public static int computeUnknownGroupSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeGroupSize(fieldNumber, value2);
    }

    public static int computeMessageSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag(value2);
    }

    public static int computeBytesSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag(value2);
    }

    public static int computeUInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag(value2);
    }

    public static int computeEnumSize(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag(value2);
    }

    public static int computeSFixed32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed32SizeNoTag(value2);
    }

    public static int computeSFixed64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed64SizeNoTag(value2);
    }

    public static int computeSInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt32SizeNoTag(value2);
    }

    public static int computeSInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag(value2);
    }

    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeMessageSize(3, value2);
    }

    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeBytesSize(3, value2);
    }

    public static int computeDoubleSizeNoTag(double value2) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value2) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(value2);
    }

    public static int computeInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(value2);
    }

    public static int computeInt32SizeNoTag(int value2) {
        if (value2 >= 0) {
            return CodedOutputStream.computeRawVarint32Size(value2);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value2) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value2) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value2) {
        return 1;
    }

    public static int computeStringSizeNoTag(String value2) {
        try {
            byte[] bytes2 = value2.getBytes("UTF-8");
            return CodedOutputStream.computeRawVarint32Size(bytes2.length) + bytes2.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.", e);
        }
    }

    public static int computeGroupSizeNoTag(MessageLite value2) {
        return value2.getSerializedSize();
    }

    @Deprecated
    public static int computeUnknownGroupSizeNoTag(MessageLite value2) {
        return CodedOutputStream.computeGroupSizeNoTag(value2);
    }

    public static int computeMessageSizeNoTag(MessageLite value2) {
        int size2 = value2.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(size2) + size2;
    }

    public static int computeBytesSizeNoTag(ByteString value2) {
        return CodedOutputStream.computeRawVarint32Size(value2.size()) + value2.size();
    }

    public static int computeUInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeRawVarint32Size(value2);
    }

    public static int computeEnumSizeNoTag(int value2) {
        return CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeSFixed32SizeNoTag(int value2) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value2) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(value2));
    }

    public static int computeSInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(value2));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public int spaceLeft() {
        if (this.output == null) {
            return this.limit - this.position;
        }
        throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array.");
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void writeRawByte(byte value2) throws IOException {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = value2;
    }

    public void writeRawByte(int value2) throws IOException {
        this.writeRawByte((byte)value2);
    }

    public void writeRawBytes(ByteString value2) throws IOException {
        this.writeRawBytes(value2, 0, value2.size());
    }

    public void writeRawBytes(byte[] value2) throws IOException {
        this.writeRawBytes(value2, 0, value2.length);
    }

    public void writeRawBytes(byte[] value2, int offset, int length) throws IOException {
        if (this.limit - this.position >= length) {
            System.arraycopy(value2, offset, this.buffer, this.position, length);
            this.position += length;
        } else {
            int bytesWritten = this.limit - this.position;
            System.arraycopy(value2, offset, this.buffer, this.position, bytesWritten);
            offset += bytesWritten;
            this.position = this.limit;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                System.arraycopy(value2, offset, this.buffer, 0, length);
                this.position = length;
            } else {
                this.output.write(value2, offset, length);
            }
        }
    }

    public void writeRawBytes(ByteString value2, int offset, int length) throws IOException {
        if (this.limit - this.position >= length) {
            value2.copyTo(this.buffer, offset, this.position, length);
            this.position += length;
        } else {
            int bytesWritten = this.limit - this.position;
            value2.copyTo(this.buffer, offset, this.position, bytesWritten);
            offset += bytesWritten;
            this.position = this.limit;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                value2.copyTo(this.buffer, offset, 0, length);
                this.position = length;
            } else {
                InputStream inputStreamFrom = value2.newInput();
                if ((long)offset != inputStreamFrom.skip(offset)) {
                    throw new IllegalStateException("Skip failed? Should never happen.");
                }
                while (length > 0) {
                    int bytesToRead = Math.min(length, this.limit);
                    int bytesRead = inputStreamFrom.read(this.buffer, 0, bytesToRead);
                    if (bytesRead != bytesToRead) {
                        throw new IllegalStateException("Read failed? Should never happen");
                    }
                    this.output.write(this.buffer, 0, bytesRead);
                    length -= bytesRead;
                }
            }
        }
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(fieldNumber, wireType));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(fieldNumber, 0));
    }

    public void writeRawVarint32(int value2) throws IOException {
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                this.writeRawByte(value2);
                return;
            }
            this.writeRawByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long value2) throws IOException {
        while (true) {
            if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value2);
                return;
            }
            this.writeRawByte((int)value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value2) {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int value2) throws IOException {
        this.writeRawByte(value2 & 0xFF);
        this.writeRawByte(value2 >> 8 & 0xFF);
        this.writeRawByte(value2 >> 16 & 0xFF);
        this.writeRawByte(value2 >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value2) throws IOException {
        this.writeRawByte((int)value2 & 0xFF);
        this.writeRawByte((int)(value2 >> 8) & 0xFF);
        this.writeRawByte((int)(value2 >> 16) & 0xFF);
        this.writeRawByte((int)(value2 >> 24) & 0xFF);
        this.writeRawByte((int)(value2 >> 32) & 0xFF);
        this.writeRawByte((int)(value2 >> 40) & 0xFF);
        this.writeRawByte((int)(value2 >> 48) & 0xFF);
        this.writeRawByte((int)(value2 >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

