/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLongs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Comparator;
import sun.misc.Unsafe;

public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value2) {
        return value2 & 0xFF;
    }

    public static byte checkedCast(long value2) {
        Preconditions.checkArgument(value2 >> 8 == 0L, "out of range: %s", value2);
        return (byte)value2;
    }

    public static byte saturatedCast(long value2) {
        if (value2 > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value2 < 0L) {
            return 0;
        }
        return (byte)value2;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedBytes.toInt(array2[i]);
            if (next2 >= min2) continue;
            min2 = next2;
        }
        return (byte)min2;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max2 = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedBytes.toInt(array2[i]);
            if (next2 <= max2) continue;
            max2 = next2;
        }
        return (byte)max2;
    }

    @Beta
    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    @Beta
    public static String toString(byte x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(UnsignedBytes.toInt(x), radix);
    }

    @Beta
    public static byte parseUnsignedByte(String string2) {
        return UnsignedBytes.parseUnsignedByte(string2, 10);
    }

    @Beta
    public static byte parseUnsignedByte(String string2, int radix) {
        int parse2 = Integer.parseInt(Preconditions.checkNotNull(string2), radix);
        if (parse2 >> 8 == 0) {
            return (byte)parse2;
        }
        throw new NumberFormatException("out of range: " + parse2);
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)theClass.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable t) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left3, byte[] right) {
                int minLength = Math.min(left3.length, right.length);
                for (int i = 0; i < minLength; ++i) {
                    int result2 = UnsignedBytes.compare(left3[i], right[i]);
                    if (result2 == 0) continue;
                    return result2;
                }
                return left3.length - right.length;
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean littleEndian;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException tryReflectionInstead) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                            @Override
                            public Unsafe run() throws Exception {
                                Class<Unsafe> k = Unsafe.class;
                                for (Field f2 : k.getDeclaredFields()) {
                                    f2.setAccessible(true);
                                    Object x = f2.get(null);
                                    if (!k.isInstance(x)) continue;
                                    return (Unsafe)k.cast(x);
                                }
                                throw new NoSuchFieldError("the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left3, byte[] right) {
                int i;
                int minLength = Math.min(left3.length, right.length);
                int minWords = minLength / 8;
                for (i = 0; i < minWords * 8; i += 8) {
                    int y;
                    long rw;
                    long lw = theUnsafe.getLong(left3, (long)BYTE_ARRAY_BASE_OFFSET + (long)i);
                    long diff2 = lw ^ (rw = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i));
                    if (diff2 == 0L) continue;
                    if (!littleEndian) {
                        return UnsignedLongs.compare(lw, rw);
                    }
                    int n = 0;
                    int x = (int)diff2;
                    if (x == 0) {
                        x = (int)(diff2 >>> 32);
                        n = 32;
                    }
                    if ((y = x << 16) == 0) {
                        n += 16;
                    } else {
                        x = y;
                    }
                    y = x << 8;
                    if (y == 0) {
                        n += 8;
                    }
                    return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
                }
                for (i = minWords * 8; i < minLength; ++i) {
                    int result2 = UnsignedBytes.compare(left3[i], right[i]);
                    if (result2 == 0) continue;
                    return result2;
                }
                return left3.length - right.length;
            }

            static {
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }
    }
}

