/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible
public final class Bytes {
    private Bytes() {
    }

    public static int hashCode(byte value2) {
        return value2;
    }

    public static boolean contains(byte[] array2, byte target) {
        for (byte value2 : array2) {
            if (value2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(byte[] array2, byte target) {
        return Bytes.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(byte[] array2, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array2, byte[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array2, byte target) {
        return Bytes.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(byte[] array2, byte target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array2 : arrays) {
            length += array2.length;
        }
        byte[] result2 = new byte[length];
        int pos = 0;
        for (byte[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static byte[] ensureCapacity(byte[] array2, int minLength, int padding2) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding2 >= 0, "Invalid padding: %s", padding2);
        return array2.length < minLength ? Bytes.copyOf(array2, minLength + padding2) : array2;
    }

    private static byte[] copyOf(byte[] original, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static byte[] toArray(Collection<? extends Number> collection2) {
        if (collection2 instanceof ByteArrayAsList) {
            return ((ByteArrayAsList)collection2).toByteArray();
        }
        Object[] boxedArray = collection2.toArray();
        int len = boxedArray.length;
        byte[] array2 = new byte[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).byteValue();
        }
        return array2;
    }

    public static List<Byte> asList(byte ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements RandomAccess,
    Serializable {
        final byte[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ByteArrayAsList(byte[] array2) {
            this(array2, 0, array2.length);
        }

        ByteArrayAsList(byte[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Byte get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Byte && Bytes.indexOf(this.array, (Byte)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Byte && (i = Bytes.indexOf(this.array, (Byte)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Byte && (i = Bytes.lastIndexOf(this.array, (Byte)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Byte set(int index2, Byte element) {
            Preconditions.checkElementIndex(index2, this.size());
            byte oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            int size2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                ByteArrayAsList that = (ByteArrayAsList)object;
                int size2 = this.size();
                if (that.size() != size2) {
                    return false;
                }
                for (int i = 0; i < size2; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i = this.start; i < this.end; ++i) {
                result2 = 31 * result2 + Bytes.hashCode(this.array[i]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        byte[] toByteArray() {
            int size2 = this.size();
            byte[] result2 = new byte[size2];
            System.arraycopy(this.array, this.start, result2, 0, size2);
            return result2;
        }
    }
}

