/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Platform;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first2, T[] second, Class<T> type) {
        T[] result2 = ObjectArrays.newArray(type, first2.length + second.length);
        System.arraycopy(first2, 0, result2, 0, first2.length);
        System.arraycopy(second, 0, result2, first2.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@Nullable T element, T[] array2) {
        T[] result2 = ObjectArrays.newArray(array2, array2.length + 1);
        result2[0] = element;
        System.arraycopy(array2, 0, result2, 1, array2.length);
        return result2;
    }

    public static <T> T[] concat(T[] array2, @Nullable T element) {
        T[] result2 = ObjectArrays.arraysCopyOf(array2, array2.length + 1);
        result2[array2.length] = element;
        return result2;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        T[] copy = ObjectArrays.newArray(original, newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array2) {
        int size2 = c.size();
        if (array2.length < size2) {
            array2 = ObjectArrays.newArray(array2, size2);
        }
        ObjectArrays.fillArray(c, array2);
        if (array2.length > size2) {
            array2[size2] = null;
        }
        return array2;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array2) {
        int i = 0;
        for (Object element : elements) {
            array2[i++] = element;
        }
        return array2;
    }

    static void swap(Object[] array2, int i, int j) {
        Object temp = array2[i];
        array2[i] = array2[j];
        array2[j] = temp;
    }

    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

