/*
 * Decompiled with CFR 0.152.
 */
package com.etsy.cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Lfs;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class LocalTap<SourceCtx, SinkCtx>
extends Tap<Properties, RecordReader, OutputCollector> {
    private static final long serialVersionUID = 3480480638297770870L;
    private static Logger LOG = Logger.getLogger(LocalTap.class.getName());
    private String path;
    private JobConf defaults;
    private Lfs lfs;

    public LocalTap(String string2, Scheme<JobConf, RecordReader, OutputCollector, SourceCtx, SinkCtx> scheme, SinkMode sinkMode) {
        super(new LocalScheme<SourceCtx, SinkCtx>(scheme), sinkMode);
        this.setup(string2, scheme);
    }

    public LocalTap(String string2, Scheme<JobConf, RecordReader, OutputCollector, SourceCtx, SinkCtx> scheme) {
        super(new LocalScheme<SourceCtx, SinkCtx>(scheme));
        this.setup(string2, scheme);
    }

    private void setup(String string2, Scheme<JobConf, RecordReader, OutputCollector, SourceCtx, SinkCtx> scheme) {
        this.path = string2;
        this.defaults = new JobConf();
        this.defaults.set("mapred.input.dir", string2);
        this.defaults.set("mapred.task.partition", "0");
        this.defaults.set("parquet.benchmark.bytes.read", "false");
        this.defaults.set("parquet.benchmark.bytes.total", "false");
        this.defaults.set("parquet.benchmark.time.read", "false");
        ((LocalScheme)this.getScheme()).setDefaults(this.defaults);
        this.lfs = new Lfs((Scheme)scheme, string2);
        ((LocalScheme)this.getScheme()).setLfs(this.lfs);
    }

    @Override
    public String getIdentifier() {
        return this.path;
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, RecordReader recordReader) throws IOException {
        JobConf jobConf = LocalTap.mergeDefaults("LocalTap#openForRead", flowProcess.getConfigCopy(), this.defaults);
        return this.lfs.openForRead(new HadoopFlowProcess(jobConf));
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, OutputCollector outputCollector) throws IOException {
        JobConf jobConf = LocalTap.mergeDefaults("LocalTap#openForWrite", flowProcess.getConfigCopy(), this.defaults);
        return this.lfs.openForWrite(new HadoopFlowProcess(jobConf));
    }

    @Override
    public boolean createResource(Properties properties) throws IOException {
        return this.lfs.createResource(LocalTap.mergeDefaults("LocalTap#createResource", properties, this.defaults));
    }

    @Override
    public boolean deleteResource(Properties properties) throws IOException {
        return this.lfs.deleteResource(LocalTap.mergeDefaults("LocalTap#deleteResource", properties, this.defaults));
    }

    @Override
    public boolean resourceExists(Properties properties) throws IOException {
        return this.lfs.resourceExists(LocalTap.mergeDefaults("LocalTap#resourceExists", properties, this.defaults));
    }

    @Override
    public long getModifiedTime(Properties properties) throws IOException {
        return this.lfs.getModifiedTime(LocalTap.mergeDefaults("LocalTap#getModifiedTime", properties, this.defaults));
    }

    private static JobConf mergeDefaults(String string2, Properties properties, JobConf jobConf) {
        LOG.fine(string2 + " is merging defaults with: " + properties);
        return HadoopUtil.createJobConf(properties, jobConf);
    }

    private static Properties overwriteProperties(Properties properties, JobConf jobConf) {
        for (Map.Entry entry2 : jobConf) {
            properties.setProperty((String)entry2.getKey(), (String)entry2.getValue());
        }
        return properties;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocalTap)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LocalTap localTap = (LocalTap)object;
        return !(this.path != null ? !this.path.equals(localTap.path) : localTap.path != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.path != null ? this.path.hashCode() : 0);
        return n;
    }

    @Override
    public String toString() {
        if (this.path != null) {
            return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[\"" + Util.sanitizeUrl(this.path) + "\"]";
        }
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[not initialized]";
    }

    private static class LocalScheme<SourceContext, SinkContext>
    extends Scheme<Properties, RecordReader, OutputCollector, SourceContext, SinkContext> {
        private static final long serialVersionUID = 5710119342340369543L;
        private Scheme<JobConf, RecordReader, OutputCollector, SourceContext, SinkContext> scheme;
        private JobConf defaults;
        private Lfs lfs;

        public LocalScheme(Scheme<JobConf, RecordReader, OutputCollector, SourceContext, SinkContext> scheme) {
            super(scheme.getSourceFields(), scheme.getSinkFields());
            this.scheme = scheme;
        }

        private void setDefaults(JobConf jobConf) {
            this.defaults = jobConf;
        }

        private void setLfs(Lfs lfs) {
            this.lfs = lfs;
        }

        @Override
        public Fields retrieveSourceFields(FlowProcess<Properties> flowProcess, Tap tap) {
            return this.scheme.retrieveSourceFields(new HadoopFlowProcess(this.defaults), this.lfs);
        }

        @Override
        public void presentSourceFields(FlowProcess<Properties> flowProcess, Tap tap, Fields fields2) {
            this.scheme.presentSourceFields(new HadoopFlowProcess(this.defaults), this.lfs, fields2);
        }

        @Override
        public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, RecordReader, OutputCollector> tap, Properties properties) {
            JobConf jobConf = LocalTap.mergeDefaults("LocalScheme#sourceConfInit", properties, this.defaults);
            this.scheme.sourceConfInit(new HadoopFlowProcess(jobConf), this.lfs, jobConf);
            LocalTap.overwriteProperties(properties, jobConf);
        }

        @Override
        public Fields retrieveSinkFields(FlowProcess<Properties> flowProcess, Tap tap) {
            return this.scheme.retrieveSinkFields(new HadoopFlowProcess(this.defaults), this.lfs);
        }

        @Override
        public void presentSinkFields(FlowProcess<Properties> flowProcess, Tap tap, Fields fields2) {
            this.scheme.presentSinkFields(new HadoopFlowProcess(this.defaults), this.lfs, fields2);
        }

        @Override
        public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, RecordReader, OutputCollector> tap, Properties properties) {
            JobConf jobConf = LocalTap.mergeDefaults("LocalScheme#sinkConfInit", properties, this.defaults);
            this.scheme.sinkConfInit(new HadoopFlowProcess(jobConf), this.lfs, jobConf);
            LocalTap.overwriteProperties(properties, jobConf);
        }

        @Override
        public boolean source(FlowProcess<Properties> flowProcess, SourceCall<SourceContext, RecordReader> sourceCall) throws IOException {
            throw new RuntimeException("LocalTap#source is never called");
        }

        @Override
        public void sink(FlowProcess<Properties> flowProcess, SinkCall<SinkContext, OutputCollector> sinkCall) throws IOException {
            throw new RuntimeException("LocalTap#sink is never called");
        }
    }
}

