/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.minlog.Log;

public class Util {
    public static boolean isAndroid;

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return Double.class;
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Long.class || type == Byte.class || type == Character.class || type == Short.class || type == Double.class;
    }

    public static void log(String message, Object object) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null");
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object));
        }
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return Log.TRACE ? Util.className(type) : type.getSimpleName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(object);
    }

    public static String className(Class type) {
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer2 = new StringBuilder(16);
            int n = Util.getDimensionCount(type);
            for (int i = 0; i < n; ++i) {
                buffer2.append("[]");
            }
            return Util.className(elementClass) + buffer2;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    static {
        try {
            Class.forName("android.os.Process");
            isAndroid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

