/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import java.util.Arrays;

public class IntArray {
    public int[] items;
    public int size;
    public boolean ordered;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int capacity) {
        this(true, capacity);
    }

    public IntArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new int[capacity];
    }

    public IntArray(IntArray array2) {
        this.ordered = array2.ordered;
        this.size = array2.size;
        this.items = new int[this.size];
        System.arraycopy(array2.items, 0, this.items, 0, this.size);
    }

    public IntArray(int[] array2) {
        this(true, array2);
    }

    public IntArray(boolean ordered, int[] array2) {
        this(ordered, array2.length);
        this.size = array2.length;
        System.arraycopy(array2, 0, this.items, 0, this.size);
    }

    public void add(int value2) {
        int[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size++] = value2;
    }

    public void addAll(IntArray array2) {
        this.addAll(array2, 0, array2.size);
    }

    public void addAll(IntArray array2, int offset, int length) {
        if (offset + length > array2.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array2.size);
        }
        this.addAll(array2.items, offset, length);
    }

    public void addAll(int[] array2) {
        this.addAll(array2, 0, array2.length);
    }

    public void addAll(int[] array2, int offset, int length) {
        int sizeNeeded = this.size + length - offset;
        int[] items2 = this.items;
        if (sizeNeeded >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(array2, offset, items2, this.size, length);
        this.size += length;
    }

    public int get(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        return this.items[index2];
    }

    public void set(int index2, int value2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        this.items[index2] = value2;
    }

    public void insert(int index2, int value2) {
        int[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items2, index2, items2, index2 + 1, this.size - index2);
        } else {
            items2[this.size] = items2[index2];
        }
        ++this.size;
        items2[index2] = value2;
    }

    public void swap(int first2, int second) {
        if (first2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(first2));
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(second));
        }
        int[] items2 = this.items;
        int firstValue = items2[first2];
        items2[first2] = items2[second];
        items2[second] = firstValue;
    }

    public boolean contains(int value2) {
        int i = this.size - 1;
        int[] items2 = this.items;
        while (i >= 0) {
            if (items2[i--] != value2) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int value2) {
        int[] items2 = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items2[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(int value2) {
        int[] items2 = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items2[i] != value2) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public int removeIndex(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        int[] items2 = this.items;
        int value2 = items2[index2];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items2, index2 + 1, items2, index2, this.size - index2);
        } else {
            items2[index2] = items2[this.size];
        }
        return value2;
    }

    public int pop() {
        return this.items[--this.size];
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    public void clear() {
        this.size = 0;
    }

    public void shrink() {
        this.resize(this.size);
    }

    public int[] ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded >= this.items.length) {
            this.resize(Math.max(8, sizeNeeded));
        }
        return this.items;
    }

    protected int[] resize(int newSize) {
        int[] newItems = new int[newSize];
        int[] items2 = this.items;
        System.arraycopy(items2, 0, newItems, 0, Math.min(items2.length, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            int temp = this.items[i];
            this.items[i] = this.items[ii];
            this.items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public int[] toArray() {
        int[] array2 = new int[this.size];
        System.arraycopy(this.items, 0, array2, 0, this.size);
        return array2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] items2 = this.items;
        StringBuilder buffer2 = new StringBuilder(32);
        buffer2.append('[');
        buffer2.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer2.append(", ");
            buffer2.append(items2[i]);
        }
        buffer2.append(']');
        return buffer2.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        int[] items2 = this.items;
        StringBuilder buffer2 = new StringBuilder(32);
        buffer2.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer2.append(separator);
            buffer2.append(items2[i]);
        }
        return buffer2.toString();
    }
}

