/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;

public class DefaultArraySerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;

        public ObjectArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    if (this.elementsCanBeNull) {
                        kryo.writeObjectOrNull(output, object[i], elementSerializer);
                        continue;
                    }
                    kryo.writeObject(output, object[i], elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    kryo.writeClassAndObject(output, object[i]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input2, Class<Object[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            Object[] object = (Object[])Array.newInstance(type.getComponentType(), length - 1);
            kryo.reference(object);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    object[i] = this.elementsCanBeNull ? kryo.readObjectOrNull(input2, elementClass, elementSerializer) : kryo.readObject(input2, elementClass, elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    object[i] = kryo.readClassAndObject(input2);
                }
            }
            return object;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] original) {
            Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length);
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }

        public void setElementsCanBeNull(boolean elementsCanBeNull) {
            this.elementsCanBeNull = elementsCanBeNull;
        }

        public void setElementsAreSameType(boolean elementsAreSameType) {
            this.elementsAreSameType = elementsAreSameType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(object[i]);
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input2, Class<String[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            String[] array2 = new String[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readString();
            }
            return array2;
        }

        @Override
        public String[] copy(Kryo kryo, String[] original) {
            String[] copy = new String[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeBoolean(object[i]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input2, Class<boolean[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            boolean[] array2 = new boolean[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readBoolean();
            }
            return array2;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] original) {
            boolean[] copy = new boolean[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeDouble(object[i]);
            }
        }

        @Override
        public double[] read(Kryo kryo, Input input2, Class<double[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            double[] array2 = new double[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readDouble();
            }
            return array2;
        }

        @Override
        public double[] copy(Kryo kryo, double[] original) {
            double[] copy = new double[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeChar(object[i]);
            }
        }

        @Override
        public char[] read(Kryo kryo, Input input2, Class<char[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            char[] array2 = new char[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readChar();
            }
            return array2;
        }

        @Override
        public char[] copy(Kryo kryo, char[] original) {
            char[] copy = new char[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeShort(object[i]);
            }
        }

        @Override
        public short[] read(Kryo kryo, Input input2, Class<short[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            short[] array2 = new short[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readShort();
            }
            return array2;
        }

        @Override
        public short[] copy(Kryo kryo, short[] original) {
            short[] copy = new short[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeLong(object[i], false);
            }
        }

        @Override
        public long[] read(Kryo kryo, Input input2, Class<long[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            long[] array2 = new long[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readLong(false);
            }
            return array2;
        }

        @Override
        public long[] copy(Kryo kryo, long[] original) {
            long[] copy = new long[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeFloat(object[i]);
            }
        }

        @Override
        public float[] read(Kryo kryo, Input input2, Class<float[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            float[] array2 = new float[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readFloat();
            }
            return array2;
        }

        @Override
        public float[] copy(Kryo kryo, float[] original) {
            float[] copy = new float[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeInt(object[i], false);
            }
        }

        @Override
        public int[] read(Kryo kryo, Input input2, Class<int[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            int[] array2 = new int[--length];
            for (int i = 0; i < length; ++i) {
                array2[i] = input2.readInt(false);
            }
            return array2;
        }

        @Override
        public int[] copy(Kryo kryo, int[] original) {
            int[] copy = new int[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.length + 1, true);
            output.writeBytes(object);
        }

        @Override
        public byte[] read(Kryo kryo, Input input2, Class<byte[]> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readBytes(length - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] original) {
            byte[] copy = new byte[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }
}

