/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodAttributes;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.PropertyAttributes;
import ch.epfl.lamp.compiler.msil.Type;

public class PropertyInfo
extends MemberInfo {
    public final short Attributes;
    public final boolean CanRead;
    public final boolean CanWrite;
    public final Type PropertyType;
    protected static final PropertyInfo[] EMPTY_ARRAY = new PropertyInfo[0];
    protected MethodInfo getter;
    protected MethodInfo setter;

    @Override
    public final int MemberType() {
        return 16;
    }

    public MethodInfo[] GetAccessors() {
        return this.GetAccessors(false);
    }

    public MethodInfo[] GetAccessors(boolean nonPublic) {
        MethodInfo getter2 = this.GetGetMethod(nonPublic);
        MethodInfo setter2 = this.GetSetMethod(nonPublic);
        if (getter2 == null) {
            if (setter2 == null) {
                return MethodInfo.EMPTY_ARRAY;
            }
            return new MethodInfo[]{setter2};
        }
        if (setter2 == null) {
            return new MethodInfo[]{getter2};
        }
        return new MethodInfo[]{getter2, setter2};
    }

    public MethodInfo GetGetMethod() {
        return this.GetGetMethod(false);
    }

    public MethodInfo GetGetMethod(boolean nonPublic) {
        return nonPublic ? this.getter : (this.getter == null || this.getter.IsPublic() ? this.getter : null);
    }

    public MethodInfo GetSetMethod() {
        return this.GetSetMethod(false);
    }

    public MethodInfo GetSetMethod(boolean nonPublic) {
        return nonPublic ? this.setter : (this.setter == null || this.setter.IsPublic() ? this.setter : null);
    }

    public String toString() {
        MethodInfo m = this.getter != null ? this.getter : this.setter;
        return MethodAttributes.accessFlagsToString((this.getter != null ? this.getter : this.setter).Attributes) + " " + PropertyAttributes.toString(this.Attributes) + this.DeclaringType + "::" + this.Name;
    }

    protected PropertyInfo(String name2, Type declType, short attr, Type propType, MethodInfo getter2, MethodInfo setter2) {
        super(name2, declType);
        this.Attributes = attr;
        this.PropertyType = propType;
        this.getter = getter2;
        this.setter = setter2;
        this.CanRead = getter2 != null;
        this.CanWrite = setter2 != null;
    }
}

