/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.ConstructedType;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.GenericParamAndConstraints;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEType;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.TypeAttributes;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

final class PEModule
extends Module {
    protected final PEFile pefile;
    private final int definingRow;
    private Type[] typeRefs = null;

    protected PEModule(PEFile pefile, int definingRow, String scopeName, Assembly assem) {
        super(pefile.getName(), pefile.getAbsolutePath(), scopeName, assem);
        this.pefile = pefile;
        this.definingRow = definingRow;
        pefile.initModule(this);
        pefile.TypeDef.load();
        this.loadGlobals();
    }

    @Override
    public Type GetType(String typeName) {
        this.initTypes();
        Object o = this.typesMap.get(typeName);
        if (o == null) {
            return null;
        }
        return o instanceof Type ? (Type)o : this.getTypeDef((Integer)o);
    }

    @Override
    protected void loadTypes() {
        int row;
        this.typeRefs = new Type[this.pefile.TypeRef.rows];
        int nbTypes = this.pefile.TypeDef.rows;
        for (row = 2; row <= nbTypes; ++row) {
            String name2 = this.pefile.TypeDef(row).getFullName();
            this.typesMap.put(name2, new Integer(row));
        }
        this.types = new Type[nbTypes - 1];
        for (row = 2; row <= nbTypes; ++row) {
            this.getTypeDef(row);
        }
    }

    Type getTypeDef(int row) {
        if (this.types[row - 2] != null) {
            return this.types[row - 2];
        }
        Table.TypeDef type = this.pefile.TypeDef(row);
        int attrs = type.Flags;
        String name2 = type.getFullName();
        Type declType = null;
        if (TypeAttributes.isNested(attrs)) {
            for (int i = 1; i <= this.pefile.NestedClass.rows; ++i) {
                this.pefile.NestedClass.readRow(i);
                if (this.pefile.NestedClass.NestedClass != row) continue;
                declType = this.getTypeDef(this.pefile.NestedClass.EnclosingClass);
            }
        }
        PEType t = new PEType(this, attrs, name2, declType, 0, this.pefile, row);
        this.types[row - 2] = t;
        this.addType(t);
        int[] tvarIdxes = this.pefile.GenericParam.getTVarIdxes(row);
        for (int i = 0; i < tvarIdxes.length; ++i) {
            GenericParamAndConstraints tvarAndConstraints = this.getTypeConstraints(tvarIdxes[i]);
            t.addTVar(tvarAndConstraints);
        }
        return t;
    }

    public GenericParamAndConstraints getTypeConstraints(int genParamIdx) {
        int tvarNumber = this.pefile.GenericParam((int)genParamIdx).Number;
        String tvarName = this.pefile.GenericParam.getName();
        boolean isInvariant = this.pefile.GenericParam.isInvariant();
        boolean isCovariant = this.pefile.GenericParam.isCovariant();
        boolean isContravariant = this.pefile.GenericParam.isContravariant();
        boolean isReferenceType = this.pefile.GenericParam.isReferenceType();
        boolean isValueType = this.pefile.GenericParam.isValueType();
        boolean hasDefaultConstructor = this.pefile.GenericParam.hasDefaultConstructor();
        int[] TypeDefOrRefIdxes = this.pefile.GenericParamConstraint.getTypeDefOrRefIdxes(genParamIdx);
        Type[] tCtrs = new Type[TypeDefOrRefIdxes.length];
        for (int i = 0; i < TypeDefOrRefIdxes.length; ++i) {
            Type tConstraint;
            tCtrs[i] = tConstraint = this.getTypeDefOrRef(TypeDefOrRefIdxes[i]);
        }
        GenericParamAndConstraints res = new GenericParamAndConstraints(tvarNumber, tvarName, tCtrs, isInvariant, isCovariant, isContravariant, isReferenceType, isValueType, hasDefaultConstructor);
        return res;
    }

    @Override
    protected void loadGlobals() {
    }

    @Override
    protected void loadCustomAttributes(Type attributeType) {
        this.initAttributes(this, 1, 0, attributeType);
    }

    Type getTypeRef(int row) {
        return this.getTypeRef(row, null);
    }

    Type getTypeRef(int row, Assembly inAssembly) {
        Type type = this.typeRefs[row - 1];
        if (type != null) {
            return type;
        }
        Table.TypeRef tr = this.pefile.TypeRef;
        tr.readRow(row);
        int tableId = Table.getTableId(11, tr.ResolutionScope);
        int refRow = tr.ResolutionScope >> Table.NoBits[11];
        String typeName = tr.getFullName();
        this.pefile.getTable(tableId).readRow(refRow);
        switch (tableId) {
            case 35: {
                String name2 = this.pefile.AssemblyRef.getName();
                if (inAssembly != null && !inAssembly.GetName().Name.equals(name2)) {
                    return null;
                }
                Assembly assem = this.getAssembly(name2);
                type = assem.GetType(typeName);
                if (type != null) break;
                Assembly asmb = this.getAssembly("mscorlib");
                type = asmb.GetType("System.Object");
                break;
            }
            case 0: {
                assert (refRow == 1);
                type = this.GetType(typeName);
                break;
            }
            case 1: {
                Type nestingType = this.getTypeRef(refRow);
                String nestedName = typeName;
                type = nestingType.GetNestedType(nestedName);
                break;
            }
            case 26: {
                type = this.getAssembly(this.pefile.ModuleRef.getName()).GetType(typeName);
            }
            default: {
                throw new RuntimeException(refRow + "@" + this.pefile.getTable(tableId).getTableName());
            }
        }
        if (this.typeRefs[row - 1] != null) {
            System.out.println("TypeRef[" + PEFile.short2hex(row) + "] " + "changing type " + this.typeRefs[row - 1] + " for type " + type);
        }
        this.typeRefs[row - 1] = type;
        assert (type != null) : "Couldn't find type " + typeName;
        return type;
    }

    private Assembly getAssembly(String name2) {
        Assembly assem = ch.epfl.lamp.compiler.msil.Assembly.getAssembly(name2);
        if (assem != null) {
            return assem;
        }
        File dir = this.pefile.getParentFile();
        assem = ch.epfl.lamp.compiler.msil.Assembly.LoadFrom(dir, name2);
        if (assem != null) {
            return assem;
        }
        try {
            dir = this.pefile.getUnderlyingFile().getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assem = ch.epfl.lamp.compiler.msil.Assembly.LoadFrom(dir, name2);
        if (assem != null) {
            return assem;
        }
        throw new RuntimeException("Cannot find assembly: " + name2);
    }

    public Type getTypeDefOrRef(int index2) {
        int tableId = Table.getTableId(0, index2);
        int row = index2 >> Table.NoBits[0];
        Type type = null;
        block0 : switch (tableId) {
            case 2: {
                type = this.getTypeDef(row);
                break;
            }
            case 1: {
                return this.getTypeRef(row);
            }
            case 27: {
                Table.TypeSpec ts = this.pefile.TypeSpec;
                ts.readRow(row);
                int posInBlobStream = ts.Signature;
                byte[] blobArrWithLengthStripped = this.pefile.Blob.getBlob(posInBlobStream);
                byte[] compressedUInt = this.compressUInt(blobArrWithLengthStripped.length);
                byte[] byteArr = new byte[blobArrWithLengthStripped.length + compressedUInt.length];
                System.arraycopy(compressedUInt, 0, byteArr, 0, compressedUInt.length);
                System.arraycopy(blobArrWithLengthStripped, 0, byteArr, compressedUInt.length, blobArrWithLengthStripped.length);
                ByteBuffer buf = ByteBuffer.wrap(byteArr);
                PEFile pEFile = this.pefile;
                pEFile.getClass();
                PEFile.Sig sig = pEFile.new PEFile.Sig(buf);
                int desc = sig.readByte();
                switch (desc) {
                    case 21: {
                        int b = sig.readByte();
                        Type instantiatedType = this.getTypeDefOrRef(sig.decodeInt());
                        int numberOfTypeArgs = sig.decodeInt();
                        Type[] typeArgs2 = new Type[numberOfTypeArgs];
                        for (int iarg = 0; iarg < numberOfTypeArgs; ++iarg) {
                            typeArgs2[iarg] = sig.decodeType();
                        }
                        type = new ConstructedType(instantiatedType, typeArgs2);
                        break block0;
                    }
                    case 19: {
                        int typeArgAsZeroBased = sig.decodeInt();
                        type = new Type.TMVarUsage(typeArgAsZeroBased, true);
                        break block0;
                    }
                    case 30: {
                        int typeArgAsZeroBased = sig.decodeInt();
                        type = new Type.TMVarUsage(typeArgAsZeroBased, false);
                        break block0;
                    }
                    case 29: {
                        sig.skipCustomMods();
                        type = Type.mkArray(sig.decodeType(), 1);
                        break block0;
                    }
                    case 20: {
                        Type elem2 = sig.decodeType();
                        int rank = sig.decodeInt();
                        int numSizes = sig.decodeInt();
                        for (int i = 0; i < numSizes; ++i) {
                            sig.decodeInt();
                        }
                        int numLoBounds = sig.decodeInt();
                        for (int i = 0; i < numLoBounds; ++i) {
                            sig.decodeInt();
                        }
                        type = Type.mkArray(elem2, rank);
                        break block0;
                    }
                }
                throw new RuntimeException("PEModule.getTypeDefOrRef(): TypeSpec");
            }
            default: {
                throw new RuntimeException("PEModule.getTypeDefOrRef(): oops!");
            }
        }
        return type;
    }

    private byte[] compressUInt(int u) {
        if (u <= 127 && 0 <= u) {
            return new byte[]{(byte)u};
        }
        if (u > 127 && u <= 15) {
            byte loByte = (byte)(u & 0xFF);
            byte hiByte = (byte)(u >> 8 | 0x80);
            byte[] res = new byte[]{hiByte, loByte};
            return res;
        }
        byte b0 = (byte)(u & 0xFF);
        byte b1 = (byte)((u & 0xFF00) >> 8);
        byte b2 = (byte)((u & 0xFF0000) >> 16);
        byte b3 = (byte)(u >> 24 | 0xC0);
        byte[] res = new byte[]{b3, b2, b1, b0};
        return res;
    }

    MethodBase getMethod(int row) {
        for (int i = 0; i < this.types.length; ++i) {
            PEType type = (PEType)this.types[i];
            if (type.methodListBeg > row || row >= type.methodListEnd) continue;
            type.initMethods();
            return type.methoddefs[row - type.methodListBeg];
        }
        throw new RuntimeException("In module " + this + ": cannot find type defining method 0x" + PEFile.int2hex(row));
    }

    protected MemberInfo getMemberRef(int row) {
        return this.getMemberRef(row, null);
    }

    protected MemberInfo getMemberRef(int row, Assembly inAssembly) {
        MethodBase member = null;
        Table.MemberRef mref = this.pefile.MemberRef;
        mref.readRow(row);
        int mtbl = Table.getTableId(5, mref.Class);
        int mind = Table.getTableIndex(5, mref.Class);
        switch (mtbl) {
            case 1: {
                Type type = this.getTypeRef(mind, inAssembly);
                if (type == null) {
                    return null;
                }
                PEFile.Sig sig = mref.getSignature();
                int callconv = sig.readByte();
                int paramCount = sig.decodeInt();
                Type retType = sig.decodeRetType();
                Type[] paramType = new Type[paramCount];
                for (int i = 0; i < paramCount; ++i) {
                    paramType[i] = sig.decodeParamType();
                }
                String memberName = mref.getName();
                member = memberName.equals(".ctor") || memberName.equals(".cctor") ? type.GetConstructor(paramType) : type.GetMethod(memberName, paramType);
                assert (member != null) : type + "::" + memberName;
                break;
            }
            case 6: 
            case 26: 
            case 27: {
                throw new RuntimeException("initCustomAttributes: " + this.pefile.getTable(mtbl).getTableName());
            }
        }
        return member;
    }

    protected void initCustomAttributes(Type attributeType) {
        this.initAttributes(this, this.definingRow, 0, attributeType);
    }

    void initAttributes(CustomAttributeProvider cap, int definingRow, int sourceTableId, Type attributeType) {
        int parentIndex = Table.encodeIndex(definingRow, 2, sourceTableId);
        Table.CustomAttribute attrs = this.pefile.CustomAttribute;
        for (int row = 1; row <= attrs.rows; ++row) {
            ConstructorInfo attrConstr = null;
            attrs.readRow(row);
            if (attrs.Parent != parentIndex) continue;
            int tableId = Table.getTableId(10, attrs.Type);
            int ind = Table.getTableIndex(10, attrs.Type);
            switch (tableId) {
                case 6: {
                    attrConstr = (ConstructorInfo)this.getMethod(ind);
                    break;
                }
                case 10: {
                    Assembly attrAssem = attributeType == null ? null : attributeType.Assembly();
                    MemberInfo mi = this.getMemberRef(ind, attrAssem);
                    if (mi == null) break;
                    assert (mi instanceof ConstructorInfo) : "Expected ConstructorInfo; found " + mi;
                    attrConstr = (ConstructorInfo)mi;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (attrConstr == null || attrConstr.DeclaringType != attributeType && attributeType != null) continue;
            cap.addCustomAttribute(attrConstr, attrs.getValue());
        }
    }
}

