/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOG = LoggerFactory.getLogger(Version.class);
    private static boolean printedVersion = false;
    public static final String CASCADING_RELEASE_MAJOR = "cascading.release.major";
    public static final String CASCADING_RELEASE_MINOR = "cascading.release.minor";
    public static final String CASCADING_BUILD_NUMBER = "cascading.build.number";
    public static final String CASCADING = "Cascading";
    public static Properties versionProperties;

    private static synchronized Properties getVersionProperties() {
        try {
            if (versionProperties == null && (versionProperties = Version.loadVersionProperties()).isEmpty()) {
                LOG.warn("unable to load version information");
            }
        }
        catch (IOException exception) {
            LOG.warn("unable to load version information", exception);
            versionProperties = new Properties();
        }
        return versionProperties;
    }

    public static synchronized void printBanner() {
        if (printedVersion) {
            return;
        }
        printedVersion = true;
        String version = Version.getVersionString();
        if (version != null) {
            LOG.info(version);
        }
    }

    public static String getVersionString() {
        if (Version.getVersionProperties().isEmpty()) {
            return null;
        }
        String releaseVersion = Version.getReleaseBuild() == null || Version.getReleaseBuild().isEmpty() ? String.format("Concurrent, Inc - %s %s", CASCADING, Version.getReleaseFull()) : String.format("Concurrent, Inc - %s %s-%s", CASCADING, Version.getReleaseFull(), Version.getReleaseBuild());
        return releaseVersion;
    }

    public static String getRelease() {
        if (Version.getVersionProperties().isEmpty()) {
            return null;
        }
        if (Version.getReleaseBuild() == null || Version.getReleaseBuild().isEmpty()) {
            return String.format("%s", Version.getReleaseFull());
        }
        return String.format("%s-%s", Version.getReleaseFull(), Version.getReleaseBuild());
    }

    public static String getReleaseFull() {
        String releaseFull = Version.getReleaseMinor() == null || Version.getReleaseMinor().isEmpty() ? Version.getReleaseMajor() : String.format("%s.%s", Version.getReleaseMajor(), Version.getReleaseMinor());
        return releaseFull;
    }

    public static boolean hasMajorMinorVersionInfo() {
        return !Util.isEmpty(Version.getReleaseMinor()) && !Util.isEmpty(Version.getReleaseMajor());
    }

    public static boolean hasAllVersionInfo() {
        return !Util.isEmpty(Version.getReleaseBuild()) && Version.hasMajorMinorVersionInfo();
    }

    public static String getReleaseBuild() {
        return Version.getVersionProperties().getProperty(CASCADING_BUILD_NUMBER);
    }

    public static String getReleaseMinor() {
        return Version.getVersionProperties().getProperty(CASCADING_RELEASE_MINOR);
    }

    public static String getReleaseMajor() {
        return Version.getVersionProperties().getProperty(CASCADING_RELEASE_MAJOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadVersionProperties() throws IOException {
        Properties properties = new Properties();
        InputStream stream = Version.class.getClassLoader().getResourceAsStream("cascading/version.properties");
        if (stream == null) {
            return properties;
        }
        try {
            properties.load(stream);
        }
        finally {
            stream.close();
        }
        stream = Version.class.getClassLoader().getResourceAsStream("cascading/build.number.properties");
        if (stream != null) {
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        return properties;
    }
}

