/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.planner.Scope;
import cascading.operation.Operation;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import cascading.tap.MultiSourceTap;
import cascading.tap.Tap;
import cascading.util.TraceUtil;
import java.beans.Expression;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.MatrixExporter;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static int ID_LENGTH = 32;
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final String HEXES = "0123456789ABCDEF";

    public static synchronized String createUniqueID() {
        String value2 = UUID.randomUUID().toString();
        return value2.toUpperCase().replaceAll("-", "");
    }

    public static String createID(String rawID) {
        return Util.createID(rawID.getBytes());
    }

    public static String createID(byte[] bytes2) {
        try {
            return Util.getHex(MessageDigest.getInstance("MD5").digest(bytes2));
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException("unable to digest string");
        }
    }

    private static String getHex(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * bytes2.length);
        for (byte b : bytes2) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static <T> T[] copy(T[] source2) {
        if (source2 == null) {
            return null;
        }
        return Arrays.copyOf(source2, source2.length);
    }

    public static String unique(String value2, String delim) {
        String[] split2 = value2.split(delim);
        LinkedHashSet values2 = new LinkedHashSet();
        Collections.addAll(values2, split2);
        return Util.join(values2, delim);
    }

    public static String join(int[] list2, String delim) {
        return Util.join(list2, delim, false);
    }

    public static String join(int[] list2, String delim, boolean printNull) {
        StringBuffer buffer2 = new StringBuffer();
        int count2 = 0;
        int[] arr$ = list2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer s2 = arr$[i$];
            if (count2 != 0) {
                buffer2.append(delim);
            }
            if (printNull || s2 != null) {
                buffer2.append(s2);
            }
            ++count2;
        }
        return buffer2.toString();
    }

    public static String join(String delim, String ... strings) {
        return Util.join(delim, false, strings);
    }

    public static String join(String delim, boolean printNull, String ... strings) {
        return Util.join(strings, delim, printNull);
    }

    public static String join(Object[] list2, String delim) {
        return Util.join(list2, delim, false);
    }

    public static String join(Object[] list2, String delim, boolean printNull) {
        return Util.join(list2, delim, printNull, 0);
    }

    public static String join(Object[] list2, String delim, boolean printNull, int beginAt) {
        return Util.join(list2, delim, printNull, beginAt, list2.length - beginAt);
    }

    public static String join(Object[] list2, String delim, boolean printNull, int beginAt, int length) {
        StringBuffer buffer2 = new StringBuffer();
        int count2 = 0;
        for (int i = beginAt; i < beginAt + length; ++i) {
            Object s2 = list2[i];
            if (count2 != 0) {
                buffer2.append(delim);
            }
            if (printNull || s2 != null) {
                buffer2.append(s2);
            }
            ++count2;
        }
        return buffer2.toString();
    }

    public static String join(Iterable iterable, String delim, boolean printNull) {
        int count2 = 0;
        StringBuilder buffer2 = new StringBuilder();
        for (Object s2 : iterable) {
            if (count2 != 0) {
                buffer2.append(delim);
            }
            if (printNull || s2 != null) {
                buffer2.append(s2);
            }
            ++count2;
        }
        return buffer2.toString();
    }

    public static String join(Collection collection2) {
        return Util.join(collection2, "\t");
    }

    public static String join(Collection collection2, String delim) {
        return Util.join(collection2, delim, false);
    }

    public static String join(Collection collection2, String delim, boolean printNull) {
        StringBuffer buffer2 = new StringBuffer();
        Util.join(buffer2, collection2, delim, printNull);
        return buffer2.toString();
    }

    public static void join(StringBuffer buffer2, Collection collection2, String delim) {
        Util.join(buffer2, collection2, delim, false);
    }

    public static void join(StringBuffer buffer2, Collection collection2, String delim, boolean printNull) {
        int count2 = 0;
        for (Object s2 : collection2) {
            if (count2 != 0) {
                buffer2.append(delim);
            }
            if (printNull || s2 != null) {
                buffer2.append(s2);
            }
            ++count2;
        }
    }

    public static String[] removeNulls(String ... strings) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (String string2 : strings) {
            if (string2 == null) continue;
            list2.add(string2);
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static Collection<String> quote(Collection<String> collection2, String quote) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (String string2 : collection2) {
            list2.add(quote + string2 + quote);
        }
        return list2;
    }

    public static String print(Collection collection2, String delim) {
        StringBuffer buffer2 = new StringBuffer();
        Util.print(buffer2, collection2, delim);
        return buffer2.toString();
    }

    public static void print(StringBuffer buffer2, Collection collection2, String delim) {
        int count2 = 0;
        for (Object s2 : collection2) {
            if (count2 != 0) {
                buffer2.append(delim);
            }
            buffer2.append("[");
            buffer2.append(s2);
            buffer2.append("]");
            ++count2;
        }
    }

    public static String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceAll("(?<=//).*:.*@", "");
    }

    public static String normalizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceAll("([^:]/)/{2,}", "$1/");
    }

    public static String toNull(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String truncate(String string2, int maxSize) {
        if ((string2 = Util.toNull(string2)).length() <= maxSize) {
            return string2;
        }
        return String.format("%s...", string2.subSequence(0, maxSize - 3));
    }

    public static String printGraph(SimpleDirectedGraph graph) {
        StringWriter writer = new StringWriter();
        Util.printGraph(writer, graph);
        return writer.toString();
    }

    public static void printGraph(PrintStream out, SimpleDirectedGraph graph) {
        PrintWriter printWriter = new PrintWriter(out);
        Util.printGraph(printWriter, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGraph(String filename, SimpleDirectedGraph graph) {
        try {
            FileWriter writer = new FileWriter(filename);
            try {
                Util.printGraph(writer, graph);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }

    private static void printGraph(Writer writer, SimpleDirectedGraph graph) {
        DOTExporter dot2 = new DOTExporter(new IntegerNameProvider(), new VertexNameProvider(){

            public String getVertexName(Object object) {
                if (object == null) {
                    return "none";
                }
                return object.toString().replaceAll("\"", "'");
            }
        }, new EdgeNameProvider<Object>(){

            @Override
            public String getEdgeName(Object object) {
                if (object == null) {
                    return "none";
                }
                return object.toString().replaceAll("\"", "'");
            }
        });
        dot2.export(writer, graph);
    }

    public static void printMatrix(PrintStream out, SimpleDirectedGraph<FlowElement, Scope> graph) {
        new MatrixExporter<FlowElement, Scope>().exportAdjacencyMatrix((Writer)new PrintWriter(out), graph);
    }

    public static void removeAllNulls(List list2) {
        while (list2.remove(null)) {
        }
    }

    @Deprecated
    public static void setTrace(Object object, String trace2) {
        TraceUtil.setTrace(object, trace2);
    }

    @Deprecated
    public static String captureDebugTrace(Class type) {
        return TraceUtil.captureDebugTrace(type);
    }

    public static String formatTrace(Pipe pipe, String message) {
        return TraceUtil.formatTrace(pipe, message);
    }

    @Deprecated
    public static String formatTrace(Tap tap, String message) {
        return TraceUtil.formatTrace(tap, message);
    }

    @Deprecated
    public static String formatTrace(Scheme scheme, String message) {
        return TraceUtil.formatTrace(scheme, message);
    }

    @Deprecated
    public static String formatTrace(Operation operation, String message) {
        return TraceUtil.formatTrace(operation, message);
    }

    public static void writeDOT(Writer writer, SimpleDirectedGraph graph, IntegerNameProvider vertexIdProvider, VertexNameProvider vertexNameProvider, EdgeNameProvider edgeNameProvider) {
        new DOTExporter(vertexIdProvider, vertexNameProvider, edgeNameProvider).export(writer, graph);
    }

    public static boolean isEmpty(String string2) {
        return string2 == null || string2.isEmpty();
    }

    private static String[] findSplitName(String path) {
        String separator = "/";
        if (path.lastIndexOf("/") < path.lastIndexOf("\\")) {
            separator = "\\\\";
        }
        String[] split2 = path.split(separator);
        path = split2[split2.length - 1];
        path = path.substring(0, path.lastIndexOf(46));
        return path.split("-(?=\\d)", 2);
    }

    public static String findVersion(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] split2 = Util.findSplitName(path);
        if (split2.length == 2) {
            return split2[1];
        }
        return null;
    }

    public static String findName(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] split2 = Util.findSplitName(path);
        if (split2.length == 0) {
            return null;
        }
        return split2[0];
    }

    public static long getSourceModified(Object confCopy, Iterator<Tap> values2, long sinkModified) throws IOException {
        long sourceModified = 0L;
        while (values2.hasNext()) {
            Tap source2 = values2.next();
            if (source2 instanceof MultiSourceTap) {
                return Util.getSourceModified(confCopy, ((MultiSourceTap)source2).getChildTaps(), sinkModified);
            }
            sourceModified = source2.getModifiedTime(confCopy);
            if (sourceModified == 0L && !source2.resourceExists(confCopy)) {
                throw new FlowException("source does not exist: " + source2);
            }
            if (sinkModified >= sourceModified) continue;
            return sourceModified;
        }
        return sourceModified;
    }

    public static long getSinkModified(Object config2, Collection<Tap> sinks) throws IOException {
        long sinkModified = Long.MAX_VALUE;
        for (Tap sink2 : sinks) {
            if (sink2.isReplace() || sink2.isUpdate()) {
                sinkModified = -1L;
                continue;
            }
            if (!sink2.resourceExists(config2)) {
                sinkModified = 0L;
                continue;
            }
            sinkModified = Math.min(sinkModified, sink2.getModifiedTime(config2));
        }
        return sinkModified;
    }

    public static String getTypeName(Type type) {
        if (type == null) {
            return null;
        }
        return type instanceof Class ? ((Class)type).getCanonicalName() : type.toString();
    }

    public static String getSimpleTypeName(Type type) {
        if (type == null) {
            return null;
        }
        return type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
    }

    public static String[] typeNames(Type[] types2) {
        String[] names2 = new String[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            names2[i] = Util.getTypeName(types2[i]);
        }
        return names2;
    }

    public static String[] simpleTypeNames(Type[] types2) {
        String[] names2 = new String[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            names2[i] = Util.getSimpleTypeName(types2[i]);
        }
        return names2;
    }

    public static boolean containsNull(Object[] values2) {
        for (Object value2 : values2) {
            if (value2 != null) continue;
            return true;
        }
        return false;
    }

    public static void safeSleep(long durationMillis) {
        try {
            Thread.sleep(durationMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Set<Class<? extends Exception>> asClasses(String classNames, String warningMessage) {
        HashSet<Class<? extends Exception>> exceptionClasses = new HashSet<Class<? extends Exception>>();
        String[] split2 = classNames.split(",");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String className : split2) {
            if (className != null) {
                className = className.trim();
            }
            if (Util.isEmpty(className)) continue;
            try {
                Class<Exception> exceptionClass = contextClassLoader.loadClass(className).asSubclass(Exception.class);
                exceptionClasses.add(exceptionClass);
            }
            catch (ClassNotFoundException exception) {
                if (Util.isEmpty(warningMessage)) continue;
                LOG.warn("{}: {}", (Object)warningMessage, (Object)className);
            }
        }
        return exceptionClasses;
    }

    public static <T> T retry(Logger logger, int retries, int secondsDelay, String message, RetryOperator<T> operator) throws Exception {
        Exception saved = null;
        for (int i = 0; i < retries; ++i) {
            try {
                return operator.operate();
            }
            catch (Exception exception) {
                if (operator.rethrow(exception)) {
                    logger.warn(message + ", but not retrying", exception);
                    throw exception;
                }
                saved = exception;
                logger.warn(message + ", attempt: " + (i + 1), exception);
                try {
                    Thread.sleep(secondsDelay * 1000);
                }
                catch (InterruptedException exception1) {
                    // empty catch block
                }
                continue;
            }
        }
        logger.warn(message + ", done retrying after attempts: " + retries, saved);
        throw saved;
    }

    public static Object createProtectedObject(Class type, Object[] parameters, Class[] parameterTypes) {
        try {
            Constructor constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (Exception exception) {
            LOG.error("unable to instantiate type: {}, with exception: {}", (Object)type.getName(), (Object)exception);
            throw new FlowException("unable to instantiate type: " + type.getName(), exception);
        }
    }

    public static boolean hasClass(String typeString) {
        try {
            Util.class.getClassLoader().loadClass(typeString);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static <T> T newInstance(String className, Object ... parameters) {
        try {
            Class<?> type = Util.class.getClassLoader().loadClass(className);
            return (T)Util.newInstance(type, parameters);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className, exception);
        }
    }

    public static <T> T newInstance(Class<T> target, Object ... parameters) {
        Expression expr2 = new Expression(target, "new", parameters);
        try {
            return (T)expr2.getValue();
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create new instance: " + target.getName() + "(" + Arrays.toString(parameters) + ")", exception);
        }
    }

    public static Object invokeStaticMethod(String typeString, String methodName, Object[] parameters, Class[] parameterTypes) {
        try {
            Class<?> type = Util.class.getClassLoader().loadClass(typeString);
            return Util.invokeStaticMethod(type, methodName, parameters, parameterTypes);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + typeString, exception);
        }
    }

    public static Object invokeStaticMethod(Class type, String methodName, Object[] parameters, Class[] parameterTypes) {
        try {
            Method method = type.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(null, parameters);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to invoke static method: " + type.getName() + "." + methodName, exception);
        }
    }

    public static Object invokeInstanceMethod(Object target, String methodName, Object[] parameters, Class[] parameterTypes) {
        try {
            Method method = target.getClass().getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(target, parameters);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to invoke instance method: " + target.getClass().getName() + "." + methodName, exception);
        }
    }

    public static <R> R returnInstanceFieldIfExistsSafe(Object target, String fieldName) {
        try {
            return Util.returnInstanceFieldIfExists(target, fieldName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeConstructor(String className, Object[] parameters, Class[] parameterTypes) {
        try {
            Class<?> type = Util.class.getClassLoader().loadClass(className);
            return Util.invokeConstructor(type, parameters, parameterTypes);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className, exception);
        }
    }

    public static <T> T invokeConstructor(Class<T> target, Object[] parameters, Class[] parameterTypes) {
        try {
            Constructor<T> constructor = target.getConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create new instance: " + target.getName() + "(" + Arrays.toString(parameters) + ")", exception);
        }
    }

    public static <R> R returnInstanceFieldIfExists(Object target, String fieldName) {
        try {
            Class<?> type = target.getClass();
            Field field2 = Util.getDeclaredField(fieldName, type);
            field2.setAccessible(true);
            return (R)field2.get(target);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to get instance field: " + target.getClass().getName() + "." + fieldName, exception);
        }
    }

    public static <R> void setInstanceFieldIfExists(Object target, String fieldName, R value2) {
        try {
            Class<?> type = target.getClass();
            Field field2 = Util.getDeclaredField(fieldName, type);
            field2.setAccessible(true);
            field2.set(target, value2);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to set instance field: " + target.getClass().getName() + "." + fieldName, exception);
        }
    }

    private static Field getDeclaredField(String fieldName, Class<?> type) {
        if (type == Object.class) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("did not find {} field on {}", (Object)fieldName, (Object)type.getName());
            }
            return null;
        }
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException exception) {
            return Util.getDeclaredField(fieldName, type.getSuperclass());
        }
    }

    @Deprecated
    public static String makeTempPath(String name2) {
        if (name2 == null || name2.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty ");
        }
        name2 = Util.cleansePathName(name2.substring(0, name2.length() < 25 ? name2.length() : 25));
        return name2 + "/" + (int)(Math.random() * 100000.0) + "/";
    }

    public static String makePath(String prefix, String name2) {
        if (name2 == null || name2.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty ");
        }
        if (prefix == null || prefix.isEmpty()) {
            prefix = Long.toString((long)(Math.random() * 1.0E10));
        }
        name2 = Util.cleansePathName(name2.substring(0, name2.length() < 25 ? name2.length() : 25));
        return prefix + "/" + name2 + "/";
    }

    public static String cleansePathName(String name2) {
        return name2.replaceAll("\\s+|\\*|\\+|/+", "_");
    }

    public static interface RetryOperator<T> {
        public T operate() throws Exception;

        public boolean rethrow(Exception var1);
    }
}

