/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.flow.planner.PlatformInfo;
import cascading.property.AppProps;
import cascading.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Update
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(Update.class);
    private static final String UPDATE_PROPERTIES = "latest.properties";
    public static final String UPDATE_CHECK_SKIP = "cascading.update.skip";
    public static final String UPDATE_URL = "cascading.update.url";
    private static final Set<PlatformInfo> platformInfoSet = Collections.synchronizedSet(new TreeSet());
    private static Timer timer;

    public static synchronized void checkForUpdate(PlatformInfo platformInfo) {
        if (Boolean.getBoolean(UPDATE_CHECK_SKIP)) {
            return;
        }
        if (platformInfo != null) {
            platformInfoSet.add(platformInfo);
        }
        if (timer != null) {
            return;
        }
        timer = new Timer("UpdateRequestTimer", true);
        timer.scheduleAtFixedRate((TimerTask)new Update(), 30000L, 86400000L);
    }

    @Override
    public void run() {
        this.checkForUpdate();
    }

    public boolean checkForUpdate() {
        if (!Version.hasMajorMinorVersionInfo()) {
            return true;
        }
        boolean isCurrentWip = Version.getReleaseFull() != null && Version.getReleaseFull().contains("wip");
        boolean isCurrentDev = Version.getReleaseFull() == null || Version.getReleaseFull().contains("wip-dev");
        URL updateCheckUrl = Update.getUpdateCheckUrl();
        if (updateCheckUrl == null) {
            return false;
        }
        if (isCurrentDev) {
            LOG.debug("current release is dev build, update url: {}", (Object)updateCheckUrl.toString());
            return true;
        }
        Properties latestProperties = Update.getUpdateProperties(updateCheckUrl);
        if (latestProperties.isEmpty()) {
            return false;
        }
        String latestMajor = latestProperties.getProperty("cascading.release.major");
        String latestMinor = latestProperties.getProperty("cascading.release.minor");
        boolean isSameMajorRelease = Update.equals(Version.getReleaseMajor(), latestMajor);
        boolean isSameMinorRelease = Update.equals(Version.getReleaseMinor(), latestMinor);
        if (isSameMajorRelease && isSameMinorRelease) {
            LOG.debug("no updates available");
            return true;
        }
        String version = latestProperties.getProperty("cascading.release.version");
        if (version == null) {
            LOG.debug("release version info not found");
        } else {
            LOG.info("newer Cascading release available: {}", (Object)version);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getUpdateProperties(URL updateUrl) {
        Properties properties;
        block6: {
            URLConnection connection = updateUrl.openConnection();
            connection.setConnectTimeout(3000);
            InputStream in = connection.getInputStream();
            try {
                Properties props = new Properties();
                props.load(connection.getInputStream());
                properties = props;
                if (in == null) break block6;
            }
            catch (Throwable throwable2) {
                try {
                    if (in != null) {
                        Update.close(in);
                    }
                    throw throwable2;
                }
                catch (IOException exception) {
                    LOG.debug("unable to fetch latest properties", exception);
                    return new Properties();
                }
            }
            Update.close(in);
        }
        return properties;
    }

    private static URL getUpdateCheckUrl() {
        String url = Update.buildURL();
        String connector = url.indexOf(63) > 0 ? "&" : "?";
        String spec = url + connector + Update.buildParamsString();
        try {
            return new URL(spec);
        }
        catch (MalformedURLException exception) {
            LOG.debug("malformed url: {}", (Object)spec, (Object)exception);
            return null;
        }
    }

    private static String buildURL() {
        String baseURL = System.getProperty(UPDATE_URL, "");
        if (baseURL.isEmpty()) {
            String releaseBuild = Version.getReleaseBuild();
            baseURL = releaseBuild != null && releaseBuild.contains("wip") ? "http://files.concurrentinc.com/cascading/" : "http://files.cascading.org/cascading/";
        }
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        baseURL = String.format("%s%s/%s", baseURL, Version.getReleaseMajor(), UPDATE_PROPERTIES);
        return baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildParamsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=");
        sb.append(Update.getClientId());
        sb.append("&instance=");
        sb.append(Update.urlEncode(AppProps.getApplicationID(null)));
        sb.append("&os-name=");
        sb.append(Update.urlEncode(Update.getProperty("os.name")));
        sb.append("&jvm-name=");
        sb.append(Update.urlEncode(Update.getProperty("java.vm.name")));
        sb.append("&jvm-version=");
        sb.append(Update.urlEncode(Update.getProperty("java.version")));
        sb.append("&os-arch=");
        sb.append(Update.urlEncode(Update.getProperty("os.arch")));
        sb.append("&product=");
        sb.append(Update.urlEncode("Cascading"));
        sb.append("&version=");
        sb.append(Update.urlEncode(Version.getReleaseFull()));
        sb.append("&version-build=");
        sb.append(Update.urlEncode(Version.getReleaseBuild()));
        sb.append("&frameworks=");
        sb.append(Update.urlEncode(Update.getProperty("cascading.app.frameworks")));
        Set<PlatformInfo> set2 = platformInfoSet;
        synchronized (set2) {
            for (PlatformInfo platformInfo : platformInfoSet) {
                sb.append("&platform-name=");
                sb.append(Update.urlEncode(platformInfo.name));
                sb.append("&platform-version=");
                sb.append(Update.urlEncode(platformInfo.version));
                sb.append("&platform-vendor=");
                sb.append(Update.urlEncode(platformInfo.vendor));
            }
            platformInfoSet.clear();
        }
        return sb.toString();
    }

    private static boolean equals(String lhs, String rhs) {
        return lhs != null && lhs.equals(rhs);
    }

    private static int getClientId() {
        try {
            return Math.abs(InetAddress.getLocalHost().hashCode());
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static String urlEncode(String param2) {
        if (param2 == null) {
            return "";
        }
        try {
            return URLEncoder.encode(param2, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            LOG.debug("unable to encode param: {}", (Object)param2, (Object)exception);
            return null;
        }
    }

    private static String getProperty(String prop) {
        return System.getProperty(prop, "");
    }

    private static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

