/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.operation.BaseOperation;
import cascading.operation.Operation;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.util.Traceable;
import cascading.util.Util;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class TraceUtil {
    private static final Map<String, Pattern> registeredApiBoundaries = new ConcurrentHashMap<String, Pattern>();

    public static void registerApiBoundary(String apiBoundary) {
        registeredApiBoundaries.put(apiBoundary, Pattern.compile(apiBoundary));
    }

    public static void unregisterApiBoundary(String apiBoundary) {
        registeredApiBoundaries.remove(apiBoundary);
    }

    public static void setTrace(Object object, String trace2) {
        Util.setInstanceFieldIfExists(object, "trace", trace2);
    }

    private static String formatTrace(Traceable traceable, String message, TraceFormatter formatter) {
        if (traceable == null) {
            return message;
        }
        String trace2 = traceable.getTrace();
        if (trace2 == null) {
            return message;
        }
        return formatter.format(trace2) + " " + message;
    }

    public static String formatTrace(final Scheme scheme, String message) {
        return TraceUtil.formatTrace(scheme, message, new TraceFormatter(){

            @Override
            public String format(String trace2) {
                return "[" + Util.truncate(scheme.toString(), 25) + "][" + trace2 + "]";
            }
        });
    }

    public static String formatRawTrace(Pipe pipe, String message) {
        return TraceUtil.formatTrace(pipe, message, new TraceFormatter(){

            @Override
            public String format(String trace2) {
                return "[" + trace2 + "]";
            }
        });
    }

    public static String formatTrace(final Pipe pipe, String message) {
        return TraceUtil.formatTrace(pipe, message, new TraceFormatter(){

            @Override
            public String format(String trace2) {
                return "[" + Util.truncate(pipe.getName(), 25) + "][" + trace2 + "]";
            }
        });
    }

    public static String formatTrace(final Tap tap, String message) {
        return TraceUtil.formatTrace(tap, message, new TraceFormatter(){

            @Override
            public String format(String trace2) {
                return "[" + Util.truncate(tap.toString(), 25) + "][" + trace2 + "]";
            }
        });
    }

    public static String formatTrace(Operation operation, String message) {
        if (!(operation instanceof BaseOperation)) {
            return message;
        }
        String trace2 = ((BaseOperation)operation).getTrace();
        if (trace2 == null) {
            return message;
        }
        return "[" + trace2 + "] " + message;
    }

    public static String captureDebugTrace(Object target) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement candidateUserCodeElement = null;
        StackTraceElement apiCallElement = null;
        Class<?> tracingBoundary = target.getClass();
        String boundaryClassName = tracingBoundary.getName();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String stackClassName = stackTraceElement.getClassName();
            boolean atApiBoundary = TraceUtil.atApiBoundary(stackTraceElement.toString());
            if (stackClassName != null && stackClassName.startsWith(boundaryClassName) || atApiBoundary) {
                if (!atApiBoundary) break;
                apiCallElement = stackTraceElement;
                break;
            }
            candidateUserCodeElement = stackTraceElement;
        }
        String userCode = candidateUserCodeElement == null ? "" : candidateUserCodeElement.toString();
        String apiCall = "";
        if (apiCallElement != null) {
            String method = apiCallElement.getMethodName();
            apiCall = method.equals("<init>") ? String.format("new %s()", TraceUtil.getSimpleClassName(apiCallElement.getClassName())) : String.format("%s()", method);
        }
        return userCode.isEmpty() ? apiCall : (apiCall.isEmpty() ? userCode : String.format("%s @ %s", apiCall, userCode));
    }

    private static Object getSimpleClassName(String className) {
        if (className == null || className.isEmpty()) {
            return "";
        }
        String[] parts = className.split("\\.");
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    private static boolean atApiBoundary(String stackTraceElement) {
        for (Pattern boundary : registeredApiBoundaries.values()) {
            if (!boundary.matcher(stackTraceElement).matches()) continue;
            return true;
        }
        return false;
    }

    private static interface TraceFormatter {
        public String format(String var1);
    }
}

