/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownUtil.class);
    private static PriorityQueue<Hook> queue = new PriorityQueue<Hook>(20, new Comparator<Hook>(){

        @Override
        public int compare(Hook lhs, Hook rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.priority().compareTo(rhs.priority());
        }
    });
    private static Thread shutdownHook;

    public static void addHook(Hook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("hook may not be null");
        }
        ShutdownUtil.registerShutdownHook();
        queue.add(hook);
    }

    public static boolean removeHook(Hook hook) {
        return queue.remove(hook);
    }

    public static synchronized void registerShutdownHook() {
        if (shutdownHook != null) {
            return;
        }
        shutdownHook = new Thread("cascading shutdown hooks"){

            @Override
            public void run() {
                while (!queue.isEmpty()) {
                    Hook hook = null;
                    try {
                        hook = (Hook)queue.poll();
                        hook.execute();
                    }
                    catch (Exception exception) {
                        LOG.error("failed executing hook: {}, with exception: {}", (Object)hook, (Object)exception);
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void deregisterShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    public static abstract class Hook {
        public abstract Priority priority();

        public abstract void execute();

        public static enum Priority {
            FIRST,
            WORK_PARENT,
            WORK_CHILD,
            SERVICE_CONSUMER,
            SERVICE_PROVIDER,
            LAST;

        }
    }
}

